package cn.com.duiba.developer.center.biz.dao.app.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.api.domain.vo.AppDeveloperVO;
import cn.com.duiba.developer.center.api.domain.vo.AppManageVO;
import cn.com.duiba.developer.center.biz.dao.app.AppDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/15.
 */
@Repository
public class AppDaoImpl extends BaseDao implements AppDao {

    @Override
    public List<AppSimpleDto> findByIds(List<Long> ids) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("ids", ids);
        return selectList("findByIds", map);
    }

    @Override
    public List<AppSimpleDto> findAll() {
        return selectList("findAll");
    }

    @Override
    public AppSimpleDto find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public void insert(AppDO app) {
        insert("insert", app);
    }

    @Override
    public void update(AppDO app) {
        update("update",app);
    }

    @Override
    public List<Long> findAllEnable() {
        return selectList("findAllEnable");
    }

    @Override
    public AppSimpleDto findForUpdate(Long id) {
        return this.selectOne("findForUpdate", id);
    }

    @Override
    public int updateSwitch(Long id, Integer appSwitch) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", id);
        map.put("appSwitch", appSwitch);
        int ret = update("updateSwitch",map);
        return ret;
    }

    @Override
    public List<AppSimpleDto> findAllBySpecifyAndBlack(List<Long> specifyAppIds,List<Long> blackAppIds){
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("specifyAppIds", specifyAppIds);
        map.put("blackAppIds", blackAppIds);
        return selectList("findAllBySpecifyAndBlack", map);
    }

    @Override
    public AppSimpleDto findByAppKey(String appKey) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appKey", appKey);
        return selectOne("findByAppKey", map);
    }

    @Override
    public List<AppSimpleDto> findAllByDeveloper(Long developerId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("developerId", developerId);
        return selectList("findAllByDeveloper", map);
    }

    @Override
    public List<AppSimpleDto> findAppNameByNameLike(String appName) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appName", appName);
        return selectList("findAppNameByNameLike", map);
    }

    @Override
    public Integer countItemAutoRecommandApp(Long itemId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("itemId", itemId);
        return selectOne("countItemAutoRecommandApp", map);
    }

    @Override
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("itemId", itemId);
        return selectList("getAutoRecommandAppIdListByItemId", map);
    }

    @Override
    public List<AppSimpleDto> findAllByDeveloperIds(List<Long> developerIds) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("developerIds", developerIds);
        return selectList("findAllByDeveloperIds", map);
    }

    @Override
    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap) {
        return selectList("findAppListByCondition",queryMap);
    }

    @Override
    public Integer findAppListCount(Map<String, Object> queryMap) {
        return selectOne("findAppListCount", queryMap);
    }

    @Override
    public AppSimpleDto findFristAppByDeveloperId(Long developerId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("developerId", developerId);
        return selectOne("findFristAppByDeveloperId",map);
    }

    @Override
    public List<AppSimpleDto> findByAppIds(List<Long> appIds) {
        return selectList("findByAppIds",appIds);
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("list", appIdList);
        return selectList("selectAppDeveloper", map);
    }

    @Override
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("start", start);
        map.put("pageSize",pageSize);
        return selectList("selectAllAppDeveloper", map);
    }

    @Override
    public Map<String, Object> selectOneAppDeveloper(Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        return selectOne("selectOneAppDeveloper", map);
    }

    @Override
    public List<Long> selectAppIdByName(String appName) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appName", appName);
        return selectList("selectAppIdByName",map);
    }

    @Override
    public List<Long> selectAppIdByEmail(String email) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("email", email);
        return selectList("selectAppIdByEmail", map);
    }

    @Override
    public List<Long> selectAppIdByEmailAndName(String email, String appName) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("email", email);
        map.put("appName", appName);
        return selectList("selectAppIdByEmailAndName", map);
    }

    @Override
    public Integer countApp() {
        return selectOne("countApp");
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("list", appIdList);
        return selectList("selectAppDeveloperByAppId", map);
    }

    @Override
    public Integer findAppCountByDevId(Long developerId) {
        return selectOne("findAppCountByDevId",developerId);
    }

    @Override
    public String findAppSecretCode(Long id) {
        return selectOne("findAppSecretCode",id);
    }

    @Override
    public int updateAppColor(Optional<AppDO> app, Optional<String> color) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("id", app.get().getId());
        params.put("color",color.get());
        return update("updateAppColor", params);
    }

}
