package cn.com.duiba.developer.center.biz.dao.app.impl;

import cn.com.duiba.developer.center.biz.dataobject.credits.AppExtraDO;
import cn.com.duiba.developer.center.biz.dao.app.AppExtraDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/18.
 */
@Repository
public class AppExtraDaoImpl extends BaseDao implements AppExtraDao {

    @Override
    public AppExtraDO findByAppId(Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        return selectOne("findByAppId", map);
    }

    @Override
    public void insert(AppExtraDO appExtraDO) {
        insert("insert",appExtraDO);
    }

    @Override
    public AppExtraDO find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public Integer update(AppExtraDO appExtraDO) {
        return update("update", appExtraDO);
    }

    @Override
    public String findCallLoginProgramByAppId(Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        return selectOne("findCallLoginProgramByAppId", map);
    }

    @Override
    public Integer updateAppConfig(Long appId, String entranceDesc,
                                   String callLoginProgram) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        map.put("entranceDesc", entranceDesc);
        map.put("callLoginProgram", callLoginProgram);
        return update("updateAppConfig", map);
    }

    @Override
    public void insertAppConfig(AppExtraDO appExtraDO) {
        insert("insertAppConfig", appExtraDO);
    }

    @Override
    public List<AppExtraDO> findByAppIds(List<Long> appIds) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appIds", appIds);
        return selectList("findByAppIds",map);
    }

    @Override
    public int updateAppPerson(Long appId, String appPerson) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        map.put("appPerson", appPerson);
        return update("updateAppPerson", map);
    }

    @Override
    public List<Long> findByAppPerson(String name) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("name", name);
        return selectList("findByAppPerson",map);
    }

}
