package cn.com.duiba.developer.center.biz.dao.applayout;

import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutDO;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;

/**
 * Created by liuyao on 16/7/29.
 */
public interface AppLayoutDao {
    /**
     * 获取布局
     * @param id
     * @author 刘瑶
     */
    public AppLayoutDO find(Long id);
    /**
     * 新建布局
     * @param appLayout
     * @author 刘瑶
     */
    public int insert(AppLayoutDO appLayout);
    /**
     * 根据AppId找出对应的布局
     * @param appId
     * @author 刘瑶
     */
    public AppLayoutDO findByAppId(Long appId);
    /**
     * 更改主题配置
     * @param brickId
     */
    public int updateTheme(Long id, Long brickId);
    /**
     * 更改主题色
     * @param color
     * @return
     */
    public int updateColor(Long id, String color);
}
