package cn.com.duiba.developer.center.biz.dao.applayout.impl;

import cn.com.duiba.developer.center.api.domain.BaseDO;
import cn.com.duiba.developer.center.biz.dao.applayout.AppLayoutDao;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutDO;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Map;

/**
 * Created by liuyao on 16/7/29.
 */
@Repository
public class AppLayoutDaoImpl extends BaseDao implements AppLayoutDao {

    @Override
    public AppLayoutDO find(Long id){
        return selectOne("find",id);
    }

    @Override
    public int insert(AppLayoutDO appLayout){
        return insert("insert", appLayout);
    }
    @Override
    public AppLayoutDO findByAppId(Long appId){
        return selectOne("findByAppId",appId);
    }


    @Override
    public int updateTheme(Long id, Long brickId) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("id", id);
        JSONObject json = new JSONObject();
        json.put("0",brickId);
        params.put("brickId",json.toJSONString());
        return update("updateTheme", params);
    }

    @Override
    public int updateColor(Long id, String color) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("id", id);
        params.put("color",color);
        return update("updateColor", params);
    }

}
