package cn.com.duiba.developer.center.biz.dao.developer;

import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;

/**
 * Created by liuyao on 16/7/18.
 */
public interface RemainingMoneyDao {
    public void insert(RemainingMoneyDto rm);

    /**
     * 查询开发者账户信息
     * @param developerId 开发者ID
     * @return
     */
    public RemainingMoneyDto findByDeveloperId(Long developerId);

    /**
     * 查询开发者账户信息(加更新锁)
     * @param developerId 开发者ID
     * @return
     */
    public RemainingMoneyDto findByDeveloperId4update(Long developerId);

    /**
     * 扣钱
     * @param id
     * @param money
     * @param rm
     * @return
     * @throws Exception
     */
    public int reduceMoney(Long id,Integer money, RemainingMoneyDto rm) throws Exception;

    /**
     * 加钱
     * @param id
     * @param money 金额
     * @return 0:失败  1:成功
     */
    public int addMoney(Long id,Integer money, RemainingMoneyDto rm) throws Exception;

    /**
     * 回款(一般是兑换失败的操作)
     * @param id
     * @param money
     */
    public int paybackMoney(Long id,Integer money, RemainingMoneyDto rm) throws Exception;
}
