package cn.com.duiba.developer.center.biz.dao.developer.impl;

import cn.com.duiba.developer.center.biz.dataobject.credits.DeveloperDO;
import cn.com.duiba.developer.center.api.domain.paramquery.ADeveloperQueryEntity;
import cn.com.duiba.developer.center.biz.dao.developer.DeveloperDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * Created by liuyao on 16/7/15.
 * 管理员DAO
 */
@Repository
public class DeveloperDaoImpl extends BaseDao implements DeveloperDao {
    @Override
    public DeveloperDO findByEmail(String email) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("email", email);
        return selectOne("findByEmail",paramMap);
    }

    @Override
    public List<DeveloperDO> findByEmailLike(String email) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("email", email);
        return selectList("findByEmailLike",paramMap);
    }

    @Override
    public List<DeveloperDO> findAllByIdList(List<Long> idList) {
        if(idList.isEmpty()){
            return Collections.emptyList();
        }
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("idList", idList);
        return selectList("findAllByIdList",paramMap);
    }

    @Override
    public List<DeveloperDO> findDeveloperPage(ADeveloperQueryEntity queryEntity) {
        return selectList("findDeveloperPage",queryEntity);
    }

    @Override
    public Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity) {
        return selectOne("findDeveloperPageCount",queryEntity);
    }

    @Override
    public DeveloperDO find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find",paramMap);
    }

    @Override
    public void insert(DeveloperDO developerDO) {
        insert("insert", developerDO);
    }

    @Override
    public int updateDeveloperSwitch(Long id,Integer developerSwitch) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("developerSwitch", developerSwitch);
        return update("updateDeveloperSwitch",paramMap);
    }

    @Override
    public int updateLastRemindTime(Long id, Date lastRemindTime) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("lastRemindTime", lastRemindTime);
        return update("updateLastRemindTime",paramMap);
    }

    @Override
    public int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("remindMoney", remindMoney);
        paramMap.put("name", name);
        paramMap.put("company", company);
        return update("updateRemindMoneyNameCompany",paramMap);
    }

    @Override
    public int updatePassword(Long id, String password) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("password", password);
        return update("updatePassword",paramMap);
    }

    @Override
    public int updateVerifyAndEnable(Long id, boolean verify, boolean enable) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("verify", verify);
        paramMap.put("enable", enable);
        return update("updateVerifyAndEnable",paramMap);
    }

    @Override
    public int updateJson(Long id, String jsonStr) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("id",id);
        params.put("json",jsonStr);
        return update("updateJson",params);
    }

    @Override
    public List<Long> findAllEnbleId() {
        return selectList("findAllEnbleId");
    }
}
