package cn.com.duiba.developer.center.biz.dao.developer.impl;

import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.developer.center.biz.exception.StatusException;
import cn.com.duiba.developer.center.biz.dao.developer.RemainingMoneyDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import cn.com.duiba.wolf.utils.SecurityUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuyao on 16/7/18.
 */
@Repository
public class RemainingMoneyDaoImpl extends BaseDao implements InitializingBean,RemainingMoneyDao {

    /**
     * 签名验证开关
     */
    @Value("#{configProperties['dcm.balance.sign']}")
    private Boolean enable;

    /**
     * 签名私钥
     */
    @Value("#{configProperties['dcm.balance.key']}")
    private String privateKey;

    public void insert(RemainingMoneyDto rm){
        insert("insert",rm);
    }

    /**
     * 查询开发者账户信息
     * @param developerId 开发者ID
     * @return
     */
    public RemainingMoneyDto findByDeveloperId(Long developerId){
        Map<String,Object> paramMap = new HashMap<String,Object>();
        paramMap.put("developerId", developerId);
        return selectOne("findByDeveloperId",paramMap);
    }

    /**
     * 查询开发者账户信息(加更新锁)
     * @param developerId 开发者ID
     * @return
     */
    public RemainingMoneyDto findByDeveloperId4update(Long developerId){
        Map<String,Object> paramMap = new HashMap<String,Object>();
        paramMap.put("developerId", developerId);
        return selectOne("findByDeveloperId4update",paramMap);
    }

    /**
     * 扣钱
     * @param id
     * @param money
     * @param rm
     * @return
     * @throws Exception
     */
    public int reduceMoney(Long id,Integer money, RemainingMoneyDto rm) throws Exception{
        if(id.longValue()!=rm.getId().longValue()){
            throw new RuntimeException("id 不一致");
        }
        if(enable){
            /**
             * 余额签名验证
             */
            if(rm.getMoney() != 0){
                String modifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(rm.getGmtModified());
                String lastSign = SecurityUtils.encode2StringByMd5(privateKey+rm.getMoney().toString()+rm.getVersion()+modifedStr);
                if(!lastSign.equals(rm.getSign())){
                    throw new StatusException(StatusException.CodeBalanceDisabled);
                }
            }
        }
        /**
         * 设置余额签名(余额+版本号+变更时间)
         */
        Integer newMoney = rm.getMoney()-money;
        Long newVersion = rm.getVersion()+1;
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5(privateKey+newMoney.toString()+newVersion+newModifedStr);

        Map<String,Object> paramMap = new HashMap<String,Object>();
        paramMap.put("id", rm.getId());
        paramMap.put("money", money);
        paramMap.put("version", rm.getVersion());
        paramMap.put("sign", newSign);
        paramMap.put("modified", newModified);
        int rows = update("reduceMoney", paramMap);
        if(rows < 1){
            throw new RuntimeException("版本过期");
        }
        return rows;
    }

    /**
     * 加钱
     * @param id
     * @param money 金额
     * @return 0:失败  1:成功
     */
    public int addMoney(Long id,Integer money, RemainingMoneyDto rm) throws Exception{
        if(id.longValue()!=rm.getId().longValue()){
            throw new RuntimeException("id 不一致");
        }
        if(enable){
            /**
             * 余额签名验证
             */
            if(rm.getMoney() != 0){
                String modifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(rm.getGmtModified());
                String lastSign = SecurityUtils.encode2StringByMd5(privateKey+rm.getMoney().toString()+rm.getVersion()+modifedStr);
                if(!lastSign.equals(rm.getSign())){
                    throw new StatusException(StatusException.CodeBalanceDisabled);
                }
            }
        }
        /**
         * 设置余额签名(余额+版本号+变更时间)
         */
        Integer newMoney = rm.getMoney()+money;
        Long newVersion = rm.getVersion()+1;
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5(privateKey+newMoney.toString()+newVersion+newModifedStr);

        Map<String,Object> paramMap = new HashMap<String,Object>();
        paramMap.put("id", rm.getId());
        paramMap.put("money", money);
        paramMap.put("version", rm.getVersion());
        paramMap.put("sign", newSign);
        paramMap.put("modified", newModified);
        int rows = update("addMoney", paramMap);
        if(rows < 1){
            throw new RuntimeException("版本过期");
        }
        return rows;
    }

    /**
     * 回款(一般是兑换失败的操作)
     * @param id
     * @param money
     */
    public int paybackMoney(Long id,Integer money, RemainingMoneyDto rm) throws Exception{
        if(id.longValue()!=rm.getId().longValue()){
            throw new RuntimeException("id 不一致");
        }
        if(enable){
            /**
             * 余额签名验证
             */
            if(rm.getMoney() != 0){
                String modifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(rm.getGmtModified());
                String lastSign = SecurityUtils.encode2StringByMd5(privateKey+rm.getMoney().toString()+rm.getVersion()+modifedStr);
                if(!lastSign.equals(rm.getSign())){
                    throw new StatusException(StatusException.CodeBalanceDisabled);
                }
            }
        }
        /**
         * 设置余额签名(余额+版本号+变更时间)
         */
        Integer newMoney = rm.getMoney()+money;
        Long newVersion = rm.getVersion()+1;
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5(privateKey+newMoney.toString()+newVersion+newModifedStr);

        Map<String,Object> paramMap = new HashMap<String,Object>();
        paramMap.put("id", rm.getId());
        paramMap.put("money", money);
        paramMap.put("version", rm.getVersion());
        paramMap.put("sign", newSign);
        paramMap.put("modified", newModified);
        int rows = update("paybackMoney", paramMap);
        if(rows < 1){
            throw new RuntimeException("版本过期");
        }
        return rows;
    }

    /**
     * 启动检查配置项
     */
    public void afterPropertiesSet() throws Exception {
        if(privateKey==null){
            throw new RuntimeException("余额签名私有key不能为null");
        }
    }

}
