package cn.com.duiba.developer.center.biz.dao.statistics.impl;

import cn.com.duiba.developer.center.biz.dao.statistics.OdpsAppItemDwmStatDao;
import cn.com.duiba.developer.center.biz.dataobject.statistics.OdpsAppItemDwmStatEntity;
import cn.com.duiba.developer.center.biz.dataobject.statistics.OdpsAppItemWeekMonthStatEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import cn.com.duiba.developer.center.common.dao.DatabaseSchema;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Repository
public class OdpsAppItemDwmStatDaoImpl extends BaseDao implements OdpsAppItemDwmStatDao {

	public OdpsAppItemDwmStatDaoImpl(){
		setDatabaseSchema(DatabaseSchema.ODPS);
	}
	@Override
	public List<OdpsAppItemDwmStatEntity> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay) {
        Map<String,Object> map = new java.util.HashMap<String,Object>();
        map.put("appId",appId);
        map.put("startDay",startDay);
        map.put("endDay",endDay);

	    return selectList("findSumByAppIdAndDayBetween",map);
	}

	@Override
	public OdpsAppItemWeekMonthStatEntity findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, Long relationId, Integer relationType) {
        Map<String,Object> map = new java.util.HashMap<String,Object>();
        map.put("appId",appId);
        map.put("startDay",startDay);
        map.put("endDay",endDay);
        map.put("relationId",relationId);
        map.put("relationType",relationType);

        return selectOne("findWeekAndMonthByAppIdAndDay",map);
	}

	@Override
	public List<OdpsAppItemDwmStatEntity> findSumByAppIdAndDayAndOrderBy(Map<String, Object> params) {
		return selectOne("findSumByAppIdAndDayAndOrderBy",params);
	}

	@Override
	public List<OdpsAppItemDwmStatEntity> findSumByAppIdAndDayAndIdAndTypeAndOrderBy(Map<String, Object> params) {
		return selectOne("findSumByAppIdAndDayAndIdAndTypeAndOrderBy",params);
	}

	@Override
	public List<OdpsAppItemWeekMonthStatEntity> findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, List<Long> relationIds, Integer relationType) {
		Map<String,Object> map = new java.util.HashMap<String,Object>();
		map.put("appId",appId);
		map.put("startDay",startDay);
		map.put("endDay",endDay);
		map.put("relationIds",relationIds);
		map.put("relationType",relationType);

		return selectOne("findWeekAndMonthByAppIdAndDay",map);
	}
}
