package cn.com.duiba.developer.center.biz.dataobject.credits;

import cn.com.duiba.developer.center.api.domain.BaseDO;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Date;

/**
 * Created by liuyao on 16/7/29.
 */
public class AppLayoutDO extends BaseDO {
    private static final long serialVersionUID = 1123L;
    private Long id;
    private Long appId;

    private String brickIds;
    private String themeColor;

    //废弃业务字段
    private String draftBrickIds;
    private String customBrickIds;
    private String draftThemeColor;


    private Date gmtCreate;
    private Date gmtModified;

    private AppLayoutBrickDO brick;

    public AppLayoutDO() {
    }

    public AppLayoutDO(boolean init4insert) {
        if (init4insert) {
            toBeInsert = true;

            draftBrickIds = "{}";
            customBrickIds = "{}";

            gmtCreate = new Date();
            gmtModified = new Date();
        }

    }

    public Long getThemeId(){
        if(StringUtils.isBlank(brickIds)){
            return null;
        }
        JSONObject json = JSONObject.parseObject(brickIds);
        return json.getLong("0")==null?1L:json.getLong("0");

    }

    public AppLayoutDO(Long id) {
        toBeUpdate = true;
        this.id = id;
        gmtModified = new Date();
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getBrickIds() {
        return brickIds;
    }

    public void setBrickIds(String brickIds) {
        this.brickIds = brickIds;
    }

    public String getThemeColor() {
        return themeColor;
    }

    public void setThemeColor(String themeColor) {
        this.themeColor = themeColor;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public AppLayoutBrickDO getBrick() {
        return brick;
    }

    public void setBrick(AppLayoutBrickDO brick) {
        this.brick = brick;
    }
}
