package cn.com.duiba.developer.center.biz.factory;

import cn.com.duiba.developer.center.api.Instruction.AppGroupInstruction;
import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppGroupDto;
import cn.com.duiba.developer.center.api.domain.dto.AppOtherDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.bo.AppLayoutBo;
import cn.com.duiba.developer.center.biz.service.credits.*;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * Created by liuyao on 16/8/2.
 */
@Component
public class AppGroupFactory {

    private Map<Class,AppGroupFactoryBean> factoryBeanMap = Maps.newHashMap();
    private Set<Class> classSet = Sets.newHashSet();

    /**
     * 向工厂中注入提供者
     * @param factoryBean
     */
    public void registFactoryBean(AppGroupFactoryBean factoryBean){
        if (Objects.equals(null,factoryBean)) throw new RuntimeException("提供者不能为空");
        factoryBeanMap.put(factoryBean.getObjectType(),factoryBean);
        classSet.add(factoryBean.getObjectType());
    }

    public AppGroupDto createAppGroup(Long id,AppGroupInstruction instruction){
        AppGroupDto group = new AppGroupDto();
        if(Objects.equals(null,id)||Objects.equals(null,instruction)){
            return group;
        }
        try{
            if(Sets.union(classSet,instruction.getClassSet()).size() > classSet.size()){
                throw new RuntimeException("AppGroupInstruction传入未知App子集类型");
            }

            Map<Class,Object> map = Maps.newHashMap();
            Iterator iterator = instruction.getClassSet().iterator();
            while (iterator.hasNext()){
                AppGroupFactoryBean factoryBean = factoryBeanMap.get(iterator.next());
                map.put(factoryBean.getObjectType(),factoryBean.getObject(id));
            }
            Field[] fields = AppGroupDto.class.getFields();
            for (int i=0;i<fields.length;i++){
                Class clazz = fields[0].getType();
                String fieldName = fields[0].getName();
                BeanUtils.setProperty(group,fieldName,map.get(clazz));
            }
        }catch (Exception e){
            throw new RuntimeException(e);
        }
        return group;
    }

}
