package cn.com.duiba.developer.center.biz.remoteservice.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppLayoutService;
import cn.com.duiba.developer.center.biz.bo.AppLayoutBo;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/27.
 */
@Service
public class RemoteAppLayoutServiceImpl implements RemoteAppLayoutService {

    @Autowired
    private AppLayoutBo appLayoutBo;

    @Override
    public DubboResult<PaginationVO<AppLayoutBrickDto>> getSystemLayoutPage(PageQueryEntity params) {

        return DubboResult.successResult(appLayoutBo.getSystemThemeLayoutPage(params));
    }

    @Override
    public DubboResult<PaginationVO<AppLayoutBrickDto>> getCustomLayoutPage(PageQueryEntity params) {
        return DubboResult.successResult(appLayoutBo.getCustomThemeLayoutPage(params));
    }
}
