package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.Instruction.AppGroupInstruction;
import cn.com.duiba.developer.center.api.domain.dto.*;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.biz.bo.AppManagerBo;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactory;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.stereotype.Service;

/**
 * Created by liuyao on 16/7/29.
 */
@Service
public class RemoteAppServiceImpl implements RemoteAppService {
    @Autowired
    private AppBo appBo;
    @Autowired
    private AppGroupFactory appGroupFactory;
    @Autowired
    private AppManagerBo appManagerBo;

    @Override
    public DubboResult<Long> CreateApp(CreateAppQueryParams param) {
        try {
            ValidatorTool.valid(param);
            return DubboResult.successResult(appBo.createApp(param));
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<AppSimpleDto> getSimpleApp(Long id) {
        return DubboResult.successResult(appBo.getSimpleApp(id));
    }

    @Override
    public DubboResult<AppGroupDto> getAppGroup(Long appId,AppGroupInstruction instruction) {
        return DubboResult.successResult(appGroupFactory.createAppGroup(appId,instruction));
    }

    @Override
    public DubboResult<Boolean> appInfo(AppInfoFromParams params) {
        try{
            ValidatorTool.valid(params);
            appManagerBo.appInfo(params);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> apiConfig(AppUrlDto urlDto) {
        try{
            ValidatorTool.valid(urlDto);
            appManagerBo.apiConfig(urlDto);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> budgetConfig(AppBudgetDto appBudget) {
        try{
            ValidatorTool.valid(appBudget);
            appManagerBo.budgetConfig(appBudget);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doSendSecret(Long appId) {
        try{
            appManagerBo.doSendSecret(appId);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }

    }


}
