package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.developer.center.api.domain.paramquery.WithdrawCashParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDevWithdrawCashService;
import cn.com.duiba.developer.center.biz.bo.DevWithdrawCashBo;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by ZQian on 2016/8/9.
 */
@Service
public class RemoteDevWithdrawCashServiceImpl implements RemoteDevWithdrawCashService {

    @Autowired
    private DevWithdrawCashBo devWithdrawCashBo;

    @Override
    public DubboResult<Tuple.Tuple2<AmbDeveloperWithdrawCashAuditDto, AmbDeveloperWithdrawCashOrderDto>> firstWithdrawToBankOrAlipay(WithdrawCashParams withdrawCashParams,
                                                                                                                                     AmbDeveloperWithdrawCashAuditDto cashAuditDO,
                                                                                                                                     AmbDeveloperWithdrawCashOrderDto cashOrderDO) throws Exception {
        return devWithdrawCashBo.firstWithdrawToBankOrAlipay(withdrawCashParams);
    }

    @Override
    public void updateAuditAndOrderStatus(AmbDeveloperWithdrawCashAuditDto cashAuditDO,
                                          AmbDeveloperWithdrawCashOrderDto cashOrderDO) throws Exception {
        devWithdrawCashBo.updateAuditAndOrderStatus(cashAuditDO, cashOrderDO);
    }
}
