package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.RechargeOrdersDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.DlpIncomeDetailDto;
import cn.com.duiba.developer.center.api.domain.dto.ManualChargeApplyDto;
import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDeveloperAccountService;
import cn.com.duiba.developer.center.biz.entity.ManualChargeApplyEntity;
import cn.com.duiba.developer.center.biz.entity.RechargeOrdersEntity;
import cn.com.duiba.developer.center.biz.entity.RemainingMoneyEntity;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperAccountService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * Created by liuyao on 16/7/25.
 */
@Service
public class RemoteDeveloperAccountServiceImpl implements RemoteDeveloperAccountService {
	private static Logger log=LoggerFactory.getLogger(RemoteDeveloperAccountService.class);
	@Autowired
	private DeveloperAccountService developerAccountService;
    @Override
    public DubboResult<RemainingMoneyDto> findRemainingMoney(Long developerId) {
        return null;
    }

    @Override
    public DubboResult<DlpIncomeDetailDto> findIncomeDetail(Long developerId) {
        return null;
    }

	@Override
	public DubboResult<Long> addRechargeOrder(RechargeOrdersDto order) {
		try{
			RechargeOrdersEntity ro = new RechargeOrdersEntity();
			ObjectUtil.convert(order, ro);
			Long ret=developerAccountService.addRechargeOrder(ro);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("addRechargeOrder error ",e);
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<RemainingMoneyDto> findDeveloperRemainingMoney(Long developerId) {
		try{
			RemainingMoneyDto rm = new RemainingMoneyDto();
			RemainingMoneyEntity ret=developerAccountService.findDeveloperRemainingMoney(developerId);
            ObjectUtil.convert(ret, rm);
            return DubboResult.successResult(rm);
        }catch(Exception e){
            log.error("findDeveloperRemainingMoney error developerId:"+developerId,e);
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<RechargeOrdersDto> findRechargeOrder(Long orderId) {
		try{
			RechargeOrdersDto rm = new RechargeOrdersDto();
			RechargeOrdersEntity ret=developerAccountService.findRechargeOrder(orderId);
            ObjectUtil.convert(ret, rm);
            return DubboResult.successResult(rm);
        }catch(Exception e){
            log.error("addRechargeOrder findRechargeOrder orderId:"+orderId,e);
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<Long> updateRechargeOrder(RechargeOrdersDto order) {
		try{
			RechargeOrdersEntity ro = new RechargeOrdersEntity();
			ObjectUtil.convert(order, ro);
			Long ret=developerAccountService.updateRechargeOrder(ro);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("addRechargeOrder updateRechargeOrder ",e);
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<Long> saveManualChargeApply(ManualChargeApplyDto manualChargeApplyDto) {
		try{
			ManualChargeApplyEntity mca = new ManualChargeApplyEntity();
			ObjectUtil.convert(manualChargeApplyDto, mca);
			Long ret=developerAccountService.saveManualChargeApply(mca);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("addRechargeOrder saveManualChargeApply ",e);
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<Long> updateManualChargeApply(ManualChargeApplyDto manualChargeApplyDto) {
		try{
			ManualChargeApplyEntity mca = new ManualChargeApplyEntity();
			ObjectUtil.convert(manualChargeApplyDto, mca);
			Long ret=developerAccountService.updateManualChargeApply(mca);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("addRechargeOrder updateManualChargeApply",e);
            return DubboResult.failResult(e.getMessage());
        }
	}
}
