package cn.com.duiba.developer.center.biz.runnble;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.bo.impl.InternalLetterBoImpl;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.DeveloperDO;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.common.support.Environment;
import cn.com.duiba.developer.center.common.tools.EmailService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;

/**
 * Created by liuyao on 16/8/11.
 */
@Component
@Scope("prototype")
public class SendSecretEmailTask implements Runnable {
    private static final Logger log= LoggerFactory.getLogger(SendSecretEmailTask.class);
    @NotNull
    private DeveloperDO developer;
    @NotNull
    private AppSimpleDto app;
    @Autowired
    private EmailService emailService;
    @Autowired
    private AppService appService;

    @Override
    public void run() {
        try {
            ValidatorTool.valid(this);
            StringBuilder sb = new StringBuilder("");
            sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            sb.append("<head>");
            sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            sb.append("<title>兑吧AppSecret</title>");
            sb.append("<link href=\"http://yun.duiba.com.cn/assets/styles/email.css\" rel=\"stylesheet\" type=\"text/css\" />");
            sb.append("</head>");
            sb.append("<body>");
            sb.append("<div class=\"main\">");
            sb.append("<h2></h2>");
            sb.append("<div>");
            sb.append("<h3>尊敬的用户: "+developer.getName()+"</h3>");
            sb.append("您好，您的App:"+ app.getName()+" 的AppSecret为："+app.getAppSecret()+"<br />");
            sb.append("请妥善保管好App的Secret码。泄露此Secret可能会给您带来风险。<br/>");
            sb.append("如遗失AppSecret，您需要联系兑吧商务人员来重新获取<br/>");
            sb.append("</div>");
            sb.append("<div>此为系统邮件，请勿回复</div>");
            sb.append("<h4>来自兑吧：<a href=\""+ Environment.getServerUrlPrefix()+ "\">"+Environment.getServerUrlPrefix() +"</a></h4>");
            sb.append("</div>");
            emailService.sendEmail(developer.getEmail(), "兑吧App Secret码", sb.toString(),true);

            AppDO app4u=new AppDO(app.getId());
            app4u.setSendSecret(true);
            appService.updata(app4u);
        } catch (Exception e) {
            log.error("发送邮件失败",e);
        }
    }

    public void setApp(AppSimpleDto app) {
        this.app = app;
    }

    public void setDeveloper(DeveloperDO developer) {
        this.developer = developer;
    }
}
