package cn.com.duiba.developer.center.biz.service.credits;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.biz.exception.StatusException;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactoryBean;
import org.springframework.beans.factory.FactoryBean;

/**
 * Created by liuyao on 16/8/2.
 */
public interface AppBudgetService extends AppGroupFactoryBean<AppBudgetDto> {

    public void clearMonthBudget(Long appId);

    public void cleanDayBudget(Long appId);
    /**
     * 扣除预算，用于创建订单流程中
     */
    public void deductBudget(Long appId, Integer actualPrice) throws StatusException;

    public AppBudgetDto findAppBudgetForUpdate(Long appId);
    /**
     * 开发者后台更新 预算控制
     */
    public boolean updateForDeveloperBack(AppBudgetDto budget);
}
