package cn.com.duiba.developer.center.biz.service.credits;

import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactoryBean;
import cn.com.duiba.developer.center.common.tools.SwicthTool;

import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.api.domain.vo.AppDeveloperVO;
import cn.com.duiba.developer.center.api.domain.vo.AppManageVO;
import cn.com.duiba.developer.center.biz.exception.StatusException;

/**
 * Created by liuyao on 16/7/18.
 */
public interface AppService extends AppGroupFactoryBean<AppSimpleDto> {

    public List<AppSimpleDto> findByIds(List<Long> ids);

    public List<AppSimpleDto> findAll();

    public void insert(AppDO app);

    /**
     * 只提供与app配置性相关属性的更新,有些终身不变,或者有专门业务的点的字段,不能在这里进行变更
     * @param app
     */
    public void updata(AppDO app);

    public List<Long> findAllEnable();

    public AppSimpleDto findForUpdate(Long id);

    public int updateSwitch(SwicthTool tool);

    public List<AppSimpleDto> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds);

    public AppSimpleDto findByAppKey(String appKey);

    public List<AppSimpleDto> findAllByDeveloper(Long developerId);

    public List<AppSimpleDto> findAppNameByNameLike(String appName);

    /**
     * 自动推荐的兑换项 推荐的app数量
     * @param itemId
     * @return
     */
    public Integer countItemAutoRecommandApp(Long itemId);
    /**
     * 获取某兑换项自动推荐的app列表
     * @param itemId
     * @return
     */
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId);

    public List<AppSimpleDto> findAllByDeveloperIds(List<Long> developerIds);

    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap);

    public Integer findAppListCount(Map<String, Object> queryMap);
    /**
     * 找到第一个创建的App
     * @param developerId
     * @return
     */
    public AppSimpleDto findFristAppByDeveloperId(Long developerId);

    public List<AppSimpleDto> findByAppIds(List<Long> appIds);

    /**
     * 根据appId列表查询多条APP+开发者信息
     * @param appIdList
     * @return
     */
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList);

    /**
     * 查询所有app
     * @param start
     * @param pageSize
     * @return
     */
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize);

    public Map<String, Object> selectOneAppDeveloper(Long appId);

    public List<Long> selectAppIdByName(String appName);

    public List<Long> selectAppIdByEmail(String email);

    public List<Long> selectAppIdByEmailAndName(String email, String appName);

    public Integer countApp();

    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList);

    public Integer findAppCountByDevId(Long developerId);

    public String getAppSecret(Long id);

}
