package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.biz.dataobject.credits.AppExtraDO;
import cn.com.duiba.developer.center.biz.dao.app.AppExtraDao;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class AppExtraServiceImpl implements AppExtraService {
    @Resource
    private AppExtraDao appExtraDao;
    @Resource
    private CacheClient cacheClient;

    private String getSimpleCacheKeyByAppId(Long appId) {
        return CacheConstants.KEY_APP_EXTRA_SIMPLE_BY_APP_ID + appId;
    }

    private String getProgramCacheKeyByAppId(Long appId) {
        return CacheConstants.KEY_APP_EXTRA_PROGRAM_BY_APP_ID + appId;
    }

    @Override
    public AppExtraDO findByAppId(Long appId) {
        String key = getSimpleCacheKeyByAppId(appId);
        AppExtraDO d = cacheClient.get(key);
        if (d == null) {
            d = appExtraDao.findByAppId(appId);
            cacheClient.set(key, d, 300);
        }
        return d;
    }

    @Override
    public AppExtraDO findByAppIdIfNullAutoCreate(Long appId) {
        AppExtraDO appExtra = findByAppId(appId);
        if (appExtra == null) {
            appExtra = new AppExtraDO(true);
            appExtra.setAppId(appId);
            insert(appExtra);
            appExtra = findByAppId(appId);
        }
        return appExtra;
    }

    @Override
    public void insert(AppExtraDO appExtraDO) {
        appExtraDao.insert(appExtraDO);
    }

    @Override
    public AppExtraDO find(Long id) {
        return appExtraDao.find(id);
    }

    @Override
    public Integer update(AppExtraDO appExtraDO) {
        Long appId = appExtraDO.getAppId();
        if (appId == null) {
            AppExtraDO d = find(appExtraDO.getId());
            if (d != null) {
                appId = d.getAppId();
            }
        }
        Integer ret = appExtraDao.update(appExtraDO);
        cacheClient.remove(getSimpleCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public void insertAppConfig(AppExtraDO appExtraDO) {
        appExtraDao.insertAppConfig(appExtraDO);
    }

    @Override
    public Integer updateAppConfig(Long appId, String entranceDesc, String callLoginProgram) {
        Integer ret = appExtraDao.updateAppConfig(appId, entranceDesc, callLoginProgram);
        cacheClient.remove(getSimpleCacheKeyByAppId(appId));
        cacheClient.remove(getProgramCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public String findCallLoginProgramByAppId(Long appId) {
        String key = getProgramCacheKeyByAppId(appId);
        String ret = cacheClient.get(key);
        if (ret == null) {
            ret = appExtraDao.findCallLoginProgramByAppId(appId);
            cacheClient.set(key, ret, 300);
        }
        return ret;
    }

    @Override
    public List<AppExtraDO> findByAppIds(List<Long> appIds) {
        return appExtraDao.findByAppIds(appIds);
    }

    @Override
    public int updateAppPerson(Long appId, String appPerson) {
        return appExtraDao.updateAppPerson(appId, appPerson);
    }

    @Override
    public List<Long> findByAppPerson(String name) {
        return appExtraDao.findByAppPerson(name);
    }
}
