package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.List;
import java.util.Objects;

import cn.com.duiba.developer.center.biz.dao.applayout.AppLayoutBrickDao;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.cache.CacheClient;

import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import cn.com.duiba.developer.center.biz.service.credits.AppLayoutBrickService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by liuyao on 16/7/28.
 */
@Service
public class AppLayoutBrickServiceImpl implements AppLayoutBrickService {
    @Autowired
    private AppLayoutBrickDao appLayoutBrickDao;
    @Resource
    private CacheClient memcachedClient;


    @Override
    public List<AppLayoutBrickDO> getSystemThemeLayoutPageList(PageQueryEntity params) {
        return appLayoutBrickDao.getAllSystemLayoutBrickList(params);
    }

    @Override
    public Integer getSystemThemeLayoutPageCount(PageQueryEntity params) {
        return appLayoutBrickDao.getSystemThemeLayoutPageCount(params);
    }

    @Override
    public List<AppLayoutBrickDO> getCustomThemeLayoutList(PageQueryEntity params) {
        return appLayoutBrickDao.getCustomThemeLayoutList(params);
    }

    @Override
    public Integer getCustomThemeLayoutCount(PageQueryEntity params) {
        return appLayoutBrickDao.getCustomThemeLayoutCount(params);
    }

    @Override
    public AppLayoutBrickDO findCacheAppLayoutBrick(Long id) {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheConstants.KEY_APP_LAYOUT_BRICK_SIMPLE_BY_ID).append(id);
        String key = sb.toString();
        AppLayoutBrickDO a = memcachedClient.get(key);
        if(Objects.equals(null,a)){
            a = appLayoutBrickDao.findWithSimple(id);
            memcachedClient.set(key, a, 300);
        }
        return a;
    }
}
