package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.biz.dao.applayout.AppLayoutDao;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutDO;
import cn.com.duiba.developer.center.biz.service.credits.AppLayoutService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * Created by liuyao on 16/7/29.
 */
@Service
public class AppLayoutServiceImpl implements AppLayoutService {

    @Autowired
    private AppLayoutDao appLayoutDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public int insert(AppLayoutDO appLayoutDO) {
        return appLayoutDao.insert(appLayoutDO);
    }

    @Override
    public AppLayoutDO findCacheAppLayout(Long appId) {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheConstants.KEY_APP_LAYOUT_BY_APPID).append(appId);
        String key = sb.toString();
        AppLayoutDO a = memcachedClient.get(key);
        if(Objects.equals(null,a)) {
            a = appLayoutDao.findByAppId(appId);
            memcachedClient.set(key, a, 300);
        }
        return a;
    }
}
