package cn.com.duiba.developer.center.biz.service.credits.impl;

import javax.annotation.PostConstruct;

import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AppOtherDto;
import cn.com.duiba.developer.center.biz.dao.app.AppOtherDao;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactory;
import cn.com.duiba.developer.center.biz.service.credits.AppOtherService;

/**
 * Created by liuyao on 16/8/2.
 */
@Service
public class AppOtherServiceImpl implements AppOtherService {
    @Autowired
    private AppOtherDao appOtherDao;

    @Autowired
    private AppGroupFactory factory;
    @Autowired
    private BizEventBus eventBus;

    @PostConstruct
    public void init(){
        eventBus.register(this);
        factory.registFactoryBean(this);
    }

    @Subscribe
    public void AppUpdateLister(AppUpdateEvent event){

    }

    @Override
    public Class<?> getObjectType() {
        return AppOtherDto.class;
    }

    @Override
    public AppOtherDto getObject(final Long appId){
        return appOtherDao.find(appId);
    }
}
