package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppUrlDto;
import cn.com.duiba.developer.center.biz.dao.app.AppUrlDao;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactory;
import cn.com.duiba.developer.center.biz.service.credits.AppUrlService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Objects;

/**
 * Created by liuyao on 16/8/2.
 */
@Service
public class AppUrlServiceImpl implements AppUrlService {

    @Resource
    private CacheClient memcachedClient;
    @Resource
    private AppUrlDao appUrlDao;
    @Autowired
    private AppGroupFactory factory;
    @Autowired
    private BizEventBus eventBus;

    @PostConstruct
    public void init(){
        eventBus.register(this);
        factory.registFactoryBean(this);
    }

    @Subscribe
    public void AppUpdateLister(AppUpdateEvent event){
        removeCacheById(event.getAppId());
    }

    @Override
    public Class<?> getObjectType() {
        return AppUrlDto.class;
    }

    @Override
    public AppUrlDto getObject(Long appId){
        AppUrlDto a = memcachedClient.get(getAppIdKey(appId));
        if(Objects.equals(null,a)) {
            a = appUrlDao.find(appId);
            memcachedClient.set(getAppIdKey(appId), a, 300);
        }
        return a;
    }

    private void removeCacheById(Long id){
        memcachedClient.remove(getAppIdKey(id));
    }

    private String getAppIdKey(Long id){
        StringBuilder sb = new StringBuilder();
        sb.append(CacheConstants.KEY_APP_URL_BY_APP_ID).append(id);
        return sb.toString();
    }


}
