package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.biz.dataobject.credits.DeveloperDO;
import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.developer.center.api.domain.paramquery.ADeveloperQueryEntity;
import cn.com.duiba.developer.center.biz.dao.developer.DeveloperDao;
import cn.com.duiba.developer.center.biz.dao.developer.RemainingMoneyDao;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class DeveloperServiceImpl implements DeveloperService {
    @Resource
    private DeveloperDao developerDao;
    @Resource
    private RemainingMoneyDao remainingMoneyDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id){
        return CacheConstants.KEY_DEVELOPER + id;
    }

    /**
     * 签名私钥
     */
    @Value("#{configProperties['dcm.balance.key']}")
    private String privateKey;

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS)
    public void insertDeveloper(DeveloperDO developer) {
        developerDao.insert(developer);
        developer = developerDao.findByEmail(developer.getEmail());
        RemainingMoneyDto rm = new RemainingMoneyDto(true);
        rm.setDeveloperId(developer.getId());
        rm.setMoney(0);
        rm.setVersion(0L);
        /**
         * 设置余额签名(余额+版本号+变更时间)
         */
        Integer newMoney = rm.getMoney();
        Long newVersion = rm.getVersion();
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5(privateKey + newMoney.toString() + newVersion + newModifedStr);
        rm.setSign(newSign);

        remainingMoneyDao.insert(rm);
    }

    @Override
    public DeveloperDO findByEmail(String email) {
        return developerDao.findByEmail(email);
    }

    @Override
    public DeveloperDO find(Long id) {
        DeveloperDO d = cacheClient.get(getCacheKeyById(id));
        if(d == null){
            d = developerDao.find(id);
            cacheClient.set(getCacheKeyById(id), d, 300);
        }
        return d;
    }

    @Override
    public List<DeveloperDO> findByEmailLike(String email) {
        return developerDao.findByEmailLike(email);
    }

    @Override
    public List<DeveloperDO> findAllByIdList(List<Long> idList) {
        return developerDao.findAllByIdList(idList);
    }

    @Override
    public List<Long> findAllEnbleId() {
        return developerDao.findAllEnbleId();
    }

    @Override
    public List<DeveloperDO> findDeveloperPage(ADeveloperQueryEntity queryEntity) {
        return developerDao.findDeveloperPage(queryEntity);
    }

    @Override
    public Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity) {
        return developerDao.findDeveloperPageCount(queryEntity);
    }

    @Override
    public void insert(DeveloperDO developerDO) {
        developerDao.insert(developerDO);
    }

    @Override
    public int updateDeveloperSwitch(Long id, Integer developerSwitch) {
        int ret = developerDao.updateDeveloperSwitch(id, developerSwitch);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateLastRemindTime(Long id, Date lastRemindTime) {
        int ret =  developerDao.updateLastRemindTime(id, lastRemindTime);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company) {
        int ret =  developerDao.updateRemindMoneyNameCompany(id, remindMoney, name, company);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updatePassword(Long id, String password) {
        int ret =  developerDao.updatePassword(id, password);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateVerifyAndEnable(Long id, boolean verify, boolean enable) {
        int ret = developerDao.updateVerifyAndEnable(id, verify, enable);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateJson(Long id, String jsonStr) {
        return developerDao.updateJson(id, jsonStr);
    }
}
