/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.api.domain.dto.AerosolDto;
import cn.com.duiba.developer.center.api.domain.dto.AerosolGroupDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppAerosolParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.entity.AerosolEntity;
import cn.com.duiba.developer.center.biz.entity.AerosolGroupEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.aerosol.AerosolGroupService;
import cn.com.duiba.developer.center.biz.service.credits.aerosol.AerosolService;
import cn.com.duiba.developer.center.biz.service.credits.aerosol.pojo.AerosolCount;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AerosolBo {
    private static final Logger logger = LoggerFactory.getLogger(AerosolBo.class);
    @Autowired
    private AerosolService aerosolService;
    @Autowired
    private AerosolGroupService aerosolGroupService;
    @Autowired
    private AppService appService;

    public AerosolDto getAerosolDto(Long appId) {
        AerosolDto dto = new AerosolDto();
        AerosolEntity entity = this.aerosolService.findByAppId(appId);
        if (entity == null) {
            return null;
        }
        dto.setId(entity.getId());
        dto.setShow(entity.getIsShow());
        dto.setAppId(entity.getAppId());
        dto.setMd5(entity.getMd5());
        dto.setConfigUrl(entity.getConfigUrl());
        dto.setGroupId(entity.getGroupId());
        dto.setAppName(entity.getAppName());
        return dto;
    }

    public AerosolDto loadAerosolNoCache(Long appId) {
        AerosolDto dto = new AerosolDto();
        AerosolEntity entity = this.aerosolService.findNoCacheByAppId(appId);
        if (entity == null) {
            return null;
        }
        dto.setId(entity.getId());
        dto.setShow(entity.getIsShow());
        dto.setAppId(entity.getAppId());
        dto.setMd5(entity.getMd5());
        dto.setConfigUrl(entity.getConfigUrl());
        dto.setGroupId(entity.getGroupId());
        dto.setAppName(entity.getAppName());
        return dto;
    }

    public List<AerosolGroupDto> loadAerosolGroup() {
        ArrayList<AerosolGroupDto> aerosolGroupDtos = new ArrayList<AerosolGroupDto>();
        List<AerosolGroupEntity> list = this.aerosolGroupService.findAerosolGroupList();
        ArrayList groupIds = Lists.newArrayList();
        for (AerosolGroupEntity entity : list) {
            groupIds.add(entity.getId());
            AerosolGroupDto aerosolGroupDto = new AerosolGroupDto();
            aerosolGroupDto.setId(entity.getId());
            aerosolGroupDto.setGroupName(entity.getGroupName());
            aerosolGroupDto.setGmtModified(entity.getGmtModified());
            aerosolGroupDtos.add(aerosolGroupDto);
        }
        List<AerosolCount> counts = this.aerosolService.findGroupCounts(groupIds);
        HashMap countMap = Maps.newHashMap();
        for (AerosolCount it : counts) {
            countMap.put(it.getGroupId(), it.getTotle());
        }
        for (AerosolGroupDto dto : aerosolGroupDtos) {
            if (countMap.containsKey(dto.getId())) {
                dto.setCount((Integer)countMap.get(dto.getId()));
                continue;
            }
            dto.setCount(Integer.valueOf(0));
        }
        return aerosolGroupDtos;
    }

    @Transactional(value="credits")
    public Boolean updateAerosolGroupShowStatus(Long groupId) throws BusinessException {
        AerosolGroupEntity group = this.aerosolGroupService.findGroupById(groupId);
        if (group == null) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u6b64groupId");
        }
        boolean isShow = group.getIsShow() == false;
        this.aerosolGroupService.updateAerosolGroupShowStatus(groupId, isShow);
        this.aerosolService.updateAerosolShowByGroupStatus(groupId, isShow);
        return isShow;
    }

    public Boolean updateAerosolShowStatus(Long appId) throws BusinessException {
        AerosolEntity entity = this.aerosolService.findNoCacheByAppId(appId);
        if (entity == null) {
            throw new BusinessException("\u8be5App\u5f53\u524d\u6ca1\u6709\u914d\u7f6e\u6d6e\u6807");
        }
        if (entity.getGroupId() != null) {
            throw new BusinessException("\u6d6e\u6807\u975e\u6e38\u79bb\u6001");
        }
        Boolean isShow = entity.getIsShow() == false;
        this.aerosolService.updateAerosolShowByAppId(appId, isShow);
        return isShow;
    }

    public Long createAerosolGroup(AerosolGroupDto groupDto) throws BusinessException {
        try {
            return this.aerosolGroupService.createAerosolGroup(groupDto);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6d6e\u6807\u5206\u7ec4\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u521b\u5efa\u6d6e\u6807\u5206\u7ec4\u5931\u8d25");
        }
    }

    @Transactional(value="credits")
    public void deleteAerosolGroup(Long id) throws BusinessException {
        try {
            this.aerosolGroupService.deleteAerosolGroup(id);
            List<AerosolEntity> aerosols = this.aerosolService.findAerosolByGroupId(id);
            HashSet appIds = Sets.newHashSet();
            for (AerosolEntity it : aerosols) {
                appIds.add(it.getAppId());
            }
            this.aerosolService.batchUpdateGroupIdToNullByAppIds(Lists.newArrayList((Iterable)appIds));
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6d6e\u6807\u5206\u7ec4\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u5220\u9664\u6d6e\u6807\u5206\u7ec4\u5931\u8d25");
        }
    }

    public void addToGroup(Long groupId, Long appId) throws BusinessException {
        AerosolGroupEntity group = this.aerosolGroupService.findGroupById(groupId);
        if (group == null) {
            throw new BusinessException("\u6d6e\u6807\u7ec4\u4e0d\u5b58\u5728");
        }
        AerosolEntity aerosol = this.aerosolService.findNoCacheByAppId(appId);
        if (aerosol == null) {
            throw new BusinessException("\u6d6e\u6807\u4e0d\u5b58\u5728");
        }
        if (aerosol.getGroupId() != null) {
            throw new BusinessException("\u6d6e\u6807\u5df2\u7ecf\u5f52\u5c5e\u5728\u7ec4\u4e2d");
        }
        this.aerosolService.comeToAerosol(appId, groupId, group.getIsShow());
    }

    public void batchAddToGroup(Long groupId, Set<Long> appIds) throws BusinessException {
        AerosolGroupEntity group = this.aerosolGroupService.findGroupById(groupId);
        if (group == null) {
            throw new BusinessException("\u6d6e\u6807\u7ec4\u4e0d\u5b58\u5728");
        }
        List<AerosolEntity> aerosols = this.aerosolService.findByAppIds(Lists.newArrayList(appIds));
        HashSet hasAerosols = Sets.newHashSet();
        for (AerosolEntity it : aerosols) {
            hasAerosols.add(it.getAppId());
        }
        this.aerosolService.batchComeToAerosol(Lists.newArrayList((Iterable)hasAerosols), groupId, group.getIsShow());
        Sets.SetView notHas = Sets.difference(appIds, (Set)hasAerosols);
        HashMap appNameMap = Maps.newHashMap();
        List<AppSimpleDto> apps = this.appService.findByAppIds(Lists.newArrayList((Iterable)notHas));
        for (AppSimpleDto app : apps) {
            appNameMap.put(app.getId(), app.getName());
        }
        ArrayList inserts = Lists.newArrayList();
        for (Long appId : notHas) {
            AerosolEntity insert = new AerosolEntity();
            insert.setAppId(appId);
            insert.setAppName((String)appNameMap.get(appId));
            insert.setMd5(group.getMd5());
            insert.setConfigUrl(group.getConfigUrl());
            insert.setGroupId(group.getId());
            insert.setIsShow(group.getIsShow());
            inserts.add(insert);
        }
        this.aerosolService.batchInsert(inserts);
    }

    public void delForGroup(Long appId) throws BusinessException {
        int ret = this.aerosolService.updateGroupIdToNullByAppId(appId);
        if (ret != 1) {
            throw new BusinessException("\u9000\u7ec4\u5931\u8d25");
        }
    }

    public void synAerosolGroup(Long groupId, Set<Long> igenoreIds) throws BusinessException {
        AerosolGroupEntity group = this.aerosolGroupService.findGroupById(groupId);
        List<AerosolEntity> aerosols = this.aerosolService.findAerosolByGroupId(groupId);
        ArrayList appIds = Lists.newArrayList();
        for (AerosolEntity it : aerosols) {
            if (igenoreIds.contains(it.getAppId())) continue;
            appIds.add(it.getAppId());
        }
        AerosolEntity update = new AerosolEntity();
        update.setMd5(group.getMd5());
        update.setConfigUrl(group.getConfigUrl());
        this.aerosolService.batchUpdateAerosol(appIds, update);
    }

    public void delAerosolByGroupId(Long groupId, Set<Long> igenoreIds) throws BusinessException {
        List<AerosolEntity> aerosols = this.aerosolService.findAerosolByGroupId(groupId);
        ArrayList appIds = Lists.newArrayList();
        for (AerosolEntity it : aerosols) {
            if (igenoreIds.contains(it.getAppId())) continue;
            appIds.add(it.getAppId());
        }
        this.aerosolService.deleteAerosolByAppIds(appIds);
    }

    public void delAerosolByAppId(Long appId) throws BusinessException {
        this.aerosolService.deleteAerosol(appId);
    }

    public void createAerosol(AerosolDto config) throws BusinessException {
        AppSimpleDto app = this.appService.getObject(config.getAppId());
        if (app == null) {
            throw new BusinessException("app\u4e0d\u5b58\u5728");
        }
        AerosolEntity entity = this.aerosolService.findNoCacheByAppId(config.getAppId());
        if (entity != null) {
            throw new BusinessException("app\u5df2\u7ecf\u5b58\u5728\u6d6e\u6807\u914d\u7f6e");
        }
        AerosolEntity insert = new AerosolEntity();
        insert.setAppId(app.getId());
        insert.setAppName(app.getName());
        insert.setGroupId(null);
        insert.setMd5(config.getMd5());
        insert.setConfigUrl(config.getConfigUrl());
        insert.setIsShow(false);
        this.aerosolService.insertAerosol(insert);
    }

    public void updateAerosol(AerosolDto config) throws BusinessException {
        AppSimpleDto app = this.appService.getObject(config.getAppId());
        if (app == null) {
            throw new BusinessException("app\u4e0d\u5b58\u5728");
        }
        AerosolEntity entity = this.aerosolService.findNoCacheByAppId(config.getAppId());
        if (entity == null) {
            throw new BusinessException("\u8be5app\u7684\u6d6e\u6807\u4e0d\u5b58\u5728");
        }
        AerosolEntity update = new AerosolEntity();
        update.setAppId(app.getId());
        update.setMd5(config.getMd5());
        update.setConfigUrl(config.getConfigUrl());
        this.aerosolService.updateAerosol(update);
    }

    public AerosolGroupDto getAerosolGroupById(Long groupId) throws BusinessException {
        AerosolGroupEntity group = this.aerosolGroupService.findGroupById(groupId);
        if (group == null) {
            return null;
        }
        AerosolGroupDto dto = new AerosolGroupDto();
        dto.setId(group.getId());
        dto.setGroupName(group.getGroupName());
        dto.setMd5(group.getMd5());
        dto.setConfigUrl(group.getConfigUrl());
        dto.setShow(group.getIsShow());
        return dto;
    }

    public Boolean updateGroupConfig(AerosolGroupDto aerosolGroupDto) throws BusinessException {
        try {
            this.aerosolGroupService.updateAerosolGroup(aerosolGroupDto);
            return true;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6d6e\u6807\u7ec4\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u66f4\u65b0\u6d6e\u6807\u7ec4\u914d\u7f6e\u5931\u8d25");
        }
    }

    public List<AerosolDto> loadGroupAppList(Long groupId) throws BusinessException {
        List<AerosolEntity> entityList = this.aerosolService.findAerosolByGroupId(groupId);
        return this.transform(entityList);
    }

    private List<AerosolDto> transform(List<AerosolEntity> entityList) {
        if (entityList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap groupName = Maps.newHashMap();
        List<AerosolGroupEntity> groupEntityList = this.aerosolGroupService.findAerosolGroupList();
        for (AerosolGroupEntity it : groupEntityList) {
            groupName.put(it.getId(), it.getGroupName());
        }
        ArrayList<AerosolDto> resultList = new ArrayList<AerosolDto>();
        for (AerosolEntity it : entityList) {
            AerosolDto aerosolDto = new AerosolDto();
            try {
                BeanUtils.copyProperties((Object)aerosolDto, (Object)((Object)it));
                if (Objects.equal((Object)it.getGroupId(), null)) {
                    aerosolDto.setGroupName("\u6e38\u79bb\u6001");
                    aerosolDto.setGroupId(null);
                } else {
                    aerosolDto.setGroupName((String)groupName.get(it.getGroupId()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            resultList.add(aerosolDto);
        }
        return resultList;
    }

    public PaginationVO<AerosolDto> loadAerosolPage(AppAerosolParams params) throws BusinessException {
        PaginationVO page = new PaginationVO();
        if (params.getAppId() != null) {
            AerosolEntity aerosolEntity = this.aerosolService.findNoCacheByAppId(params.getAppId());
            if (aerosolEntity == null) {
                return page;
            }
            ArrayList list = Lists.newArrayList();
            list.add(aerosolEntity);
            page.setRows(this.transform(list));
            page.setTotalCount(Long.valueOf(1L));
            return page;
        }
        if (StringUtils.isNotBlank((String)params.getGroupName())) {
            List<Long> groupIds = this.aerosolGroupService.findGroupIdByGroupNameLike(params.getGroupName());
            params.setGroupIds(groupIds);
        }
        PaginationVO<AerosolEntity> entityPaginationVO = this.aerosolService.findAerosolPage(params);
        page.setRows(this.transform(entityPaginationVO.getRows()));
        page.setTotalCount(entityPaginationVO.getTotalCount());
        return page;
    }

    public List<AerosolDto> loadAerosolByAppIds(Set<Long> appIds) throws BusinessException {
        List<AerosolEntity> list = this.aerosolService.findByAppIds(Lists.newArrayList(appIds));
        ArrayList resultList = Lists.newArrayList();
        resultList.addAll(this.transform(list));
        if (appIds.size() == list.size()) {
            return resultList;
        }
        HashSet hasSet = Sets.newHashSet();
        for (AerosolDto it : resultList) {
            hasSet.add(it.getAppId());
        }
        List<AppSimpleDto> appList = this.appService.findByAppIds(Lists.newArrayList((Iterable)Sets.difference(appIds, (Set)hasSet)));
        for (AppSimpleDto app : appList) {
            AerosolDto aerosolDto = new AerosolDto();
            aerosolDto.setAppId(app.getId());
            aerosolDto.setAppName(app.getName());
            aerosolDto.setGroupName("\u672a\u521b\u5efa");
            resultList.add(aerosolDto);
        }
        return resultList;
    }
}

