/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.api.domain.dto.AppBulletinDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.bo.AerosolBo;
import cn.com.duiba.developer.center.biz.service.credits.AppBulletinService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppBulletinBo {
    private static final Logger logger = LoggerFactory.getLogger(AerosolBo.class);
    @Autowired
    private AppService appService;
    @Autowired
    private AppBulletinService appBulletinService;
    private Cache<Long, AppBulletinDto> appBulletinCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public AppBulletinDto getAppBulletin(Long appId) throws BusinessException {
        LoadAppBulletin load = new LoadAppBulletin();
        load.setAppId(appId);
        try {
            return (AppBulletinDto)this.appBulletinCache.get((Object)appId, (Callable)load);
        }
        catch (Exception e) {
            return new AppBulletinDto(Boolean.valueOf(false));
        }
    }

    public String getdetailText(Long appId) {
        return this.appBulletinService.findContextByAppId(appId);
    }

    private class LoadAppBulletin
    implements Callable<AppBulletinDto> {
        private Long appId;

        private LoadAppBulletin() {
        }

        @Override
        public AppBulletinDto call() {
            try {
                AppSimpleDto app = AppBulletinBo.this.appService.getObject(this.appId);
                if (app == null) {
                    throw new BusinessException("app\u4e0d\u5b58\u5728");
                }
                if (!app.isAppSwitch(15)) {
                    return new AppBulletinDto(Boolean.valueOf(false));
                }
                AppBulletinDto dto = AppBulletinBo.this.appBulletinService.createAppBulletinDto(this.appId);
                if (dto == null) {
                    throw new BusinessException("App\u9996\u9875\u516c\u544a\u914d\u7f6e\u4e0d\u5b58\u5728");
                }
                return dto;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u9996\u9875\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
                return new AppBulletinDto(Boolean.valueOf(false));
            }
        }

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }
    }
}

