/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.common.tools.DateUtil;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppTradingLimitBo {
    private final String APP_NAMESPACE = "app_trading";
    @Autowired
    private CacheClient memcachedClient;

    public void addTrading(Long appId) {
        String key = this.getKey(appId);
        this.memcachedClient.incr(key, 1L, 1L, (long)DateUtil.getToTomorrowSeconds(), TimeUnit.SECONDS);
    }

    public Integer getTodayTradingCount(Long appId) {
        String key = this.getKey(appId);
        Integer count = (Integer)this.memcachedClient.get(key);
        if (Objects.equals(null, count)) {
            return 0;
        }
        return count;
    }

    public void resetTodayTradingCount(Long appId) {
        String key = this.getKey(appId);
        this.memcachedClient.remove(key);
    }

    private String getKey(Long appId) {
        StringBuilder sb = new StringBuilder();
        sb.append("app_trading").append(appId);
        return sb.toString();
    }
}

