/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateDeveloperParams;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.event.DeveloperCreateEvent;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.MessageDigestUtils;
import cn.com.duiba.developer.center.common.tools.SwitchTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.google.common.base.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeveloperBo {
    @Autowired
    private DeveloperService developerService;
    private static final BeanCopier DEVELOPER_COPY = BeanCopier.create(DeveloperEntity.class, DeveloperDto.class, (boolean)false);
    @Value(value="${dcm.login.encrypt.key}")
    private String loginEncryptKey;
    @Autowired
    private BizEventBus eventBus;

    @Transactional(value="credits")
    public Long createDeveloper(CreateDeveloperParams params, Boolean needVerify) throws BusinessException {
        DeveloperEntity developer = this.developerService.findByEmail(params.getEmail());
        if (!Objects.equal((Object)((Object)developer), null)) {
            throw new BusinessException("\u6b64\u90ae\u7bb1\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e86");
        }
        DeveloperEntity insert = new DeveloperEntity(true);
        if (needVerify != null && !needVerify.booleanValue()) {
            insert.setVerify(true);
        }
        insert.setEmail(params.getEmail());
        insert.setName(params.getName());
        insert.setPhone(params.getPhone());
        insert.setCompany(params.getCompany());
        String password = BlowfishUtils.encryptBlowfish((String)MessageDigestUtils.SHA((String)params.getPassword()), (String)this.loginEncryptKey);
        insert.setPassword(password);
        this.developerService.insertDeveloper(insert);
        developer = this.developerService.findByEmail(params.getEmail());
        SwitchTool tool = SwitchTool.getSwitchTool((Long)developer.getId(), (Integer)developer.getDeveloperSwitch());
        tool.setSwitchByBoundType(2, true);
        this.developerService.updateDeveloperSwitch(tool);
        DeveloperCreateEvent event = new DeveloperCreateEvent();
        event.setAppName(params.getAppName());
        event.setDeveloper(developer);
        this.eventBus.post((Object)event);
        return developer.getId();
    }

    public DeveloperDto findDeveloperByEmail(String email) {
        DeveloperEntity developer = this.developerService.findByEmail(email);
        return this.transform(developer);
    }

    private DeveloperDto transform(DeveloperEntity developer) {
        DeveloperDto developerDto = new DeveloperDto();
        try {
            DEVELOPER_COPY.copy((Object)developer, (Object)developerDto, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return developerDto;
    }
}

