/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.entity.AppExtraEntity;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.biz.event.DeveloperCreateEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.AppIdGenerator;
import cn.com.duiba.developer.center.common.tools.SecureTool;
import cn.com.duiba.developer.center.common.tools.SwitchTool;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppBoImpl
implements AppBo {
    private static final Logger log = LoggerFactory.getLogger(AppBoImpl.class);
    @Autowired
    private AppService appService;
    @Autowired
    private AppExtraService appExtraService;
    @Autowired
    private BizEventBus eventBus;

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
    }

    @Override
    public Long createApp(CreateAppQueryParams params) throws BusinessException {
        AppDO app = new AppDO(true);
        app.setName(params.getName());
        app.setCreditsRate(params.getCreditsRate());
        app.setAppKey(AppIdGenerator.generate());
        String appSecretCode = AppIdGenerator.generate();
        app.setAppSecretCode(SecureTool.encryptAppSecret((String)appSecretCode));
        app.setDeveloperId(params.getDeveloperId());
        app.setBudget(null);
        app.setBudgetRemain(null);
        app.setDayBudget(null);
        app.setDayBudgetRemain(null);
        app.setUnitName(params.getUnitName());
        List categoryList = params.getCategory();
        app.setCategory1((String)categoryList.get(0));
        if (categoryList.size() == 2) {
            app.setCategory2((String)categoryList.get(1));
        }
        this.appService.insert(app);
        SwitchTool tool = SwitchTool.getSwitchTool((Long)app.getId(), (Integer)app.getAppSwitch());
        tool.setSwitchByBoundType(6, true);
        tool.setSwitchByBoundType(9, true);
        tool.setSwitchByBoundType(10, true);
        tool.setSwitchByBoundType(11, true);
        if (params.getMallCredits().booleanValue()) {
            tool.setSwitchByBoundType(18, true);
            tool.setSwitchByBoundType(12, true);
            tool.setSwitchByBoundType(7, true);
        }
        this.appService.updateSwitch(tool);
        AppCreateEvent event = new AppCreateEvent(app);
        this.eventBus.post((Object)event);
        return app.getId();
    }

    @Subscribe
    public void createFristAppListener(DeveloperCreateEvent event) {
        if (StringUtils.isBlank((String)event.getAppName())) {
            return;
        }
        DeveloperEntity developer = event.getDeveloper();
        CreateAppQueryParams params = new CreateAppQueryParams();
        params.setDeveloperId(developer.getId());
        params.setName(event.getAppName());
        params.setCreditsRate(Integer.valueOf(100));
        params.setUnitName("\u91d1\u5e01");
        params.setCategory(new String[]{"\u5de5\u5177"});
        try {
            this.createApp(params);
        }
        catch (BusinessException e) {
            log.error("\u5f00\u53d1\u8005:" + developer.getEmail() + "\u521b\u5efa\u7b2c\u4e00\u4e2aApp\u5931\u8d25");
        }
    }

    @Override
    @Transactional(value="credits")
    public void updateAppConfig(Long appId, String entranceDesc, String callLoginProgram, String appType, String useloginCode, String freeItemVip, String exchangeCreditsType) {
        AppExtraEntity appExtraEntity = this.appExtraService.findByAppId(appId);
        if (null == appExtraEntity) {
            appExtraEntity = new AppExtraEntity();
            appExtraEntity.setAppId(appId);
            appExtraEntity.setEntranceDesc(entranceDesc);
            appExtraEntity.setCallLoginProgram(callLoginProgram);
            this.appExtraService.insertAppConfig(appExtraEntity);
        } else {
            this.appExtraService.updateAppConfig(appId, entranceDesc, callLoginProgram);
        }
        AppSimpleDto app = this.appService.getObject(appId);
        SwitchTool tool = SwitchTool.getSwitchTool((Long)app.getId(), (Integer)app.getAppSwitch());
        tool.setSwitchByBoundType(12, "on".equals(appType));
        tool.setSwitchByBoundType(13, "on".equals(useloginCode));
        tool.setSwitchByBoundType(14, "on".equals(freeItemVip));
        tool.setSwitchByBoundType(16, "on".equals(exchangeCreditsType));
        this.appService.updateSwitch(tool);
    }

    @Override
    public AppSimpleDto getSimpleApp(Long id) {
        return this.appService.getObject(id);
    }
}

