/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.bo.AppLayoutBo;
import cn.com.duiba.developer.center.biz.dao.statistics.OdpsAppLayoutStatDao;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import cn.com.duiba.developer.center.biz.dataobject.statistics.AppLayoutCountDo;
import cn.com.duiba.developer.center.biz.entity.AppLayoutEntity;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.event.FloorSkinUpdateEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutBrickService;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinSpecifyService;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.BaseJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.FloorSortJson;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.DateUtil;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.cache.CacheClient;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppLayoutBoImpl
implements AppLayoutBo {
    private static final Logger log = LoggerFactory.getLogger(AppLayoutBoImpl.class);
    @Autowired
    private AppLayoutBrickService appLayoutBrickService;
    @Autowired
    private AppLayoutService appLayoutService;
    @Autowired
    private OdpsAppLayoutStatDao odpsAppLayoutStatDao;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private AppService appService;
    @Autowired
    private CreditsFloorSkinService creditsFloorSkinService;
    @Autowired
    private CreditsFloorSkinSpecifyService creditsFloorSkinSpecifyService;
    @Autowired
    private CacheClient memcachedClient;
    @Value(value="${dcm.theme.defaultId}")
    private String defaultThemeId;
    private Ordering<AppLayoutBrickDO> ordering = Ordering.natural().onResultOf((Function)new Function<AppLayoutBrickDO, Integer>(){

        public Integer apply(AppLayoutBrickDO arg0) {
            return arg0.getPayload();
        }
    });

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
    }

    @Override
    public PaginationVO<AppLayoutBrickDto> getSystemThemeLayoutPage(PageQueryEntity params) {
        PaginationVO page = new PaginationVO();
        List list = this.appLayoutBrickService.getSystemThemeLayoutPageList(params);
        list = this.ordering.sortedCopy(list);
        AppLayoutTransform transformTool = new AppLayoutTransform((Optional<List<AppLayoutBrickDO>>)Optional.of((Object)list));
        transformTool.setNeedSetAppCount(true);
        Integer count = this.appLayoutBrickService.getSystemThemeLayoutPageCount(params);
        page.setRows(transformTool.transform());
        page.setTotalCount(Long.valueOf(count.longValue()));
        return page;
    }

    @Override
    public PaginationVO<AppLayoutBrickDto> getCustomThemeLayoutPage(PageQueryEntity params) {
        PaginationVO page = new PaginationVO();
        List list = this.appLayoutBrickService.getCustomThemeLayoutList(params);
        list = this.ordering.sortedCopy(list);
        AppLayoutTransform transformTool = new AppLayoutTransform((Optional<List<AppLayoutBrickDO>>)Optional.of((Object)list));
        Integer count = this.appLayoutBrickService.getCustomThemeLayoutCount(params);
        page.setRows(transformTool.transform());
        page.setTotalCount(Long.valueOf(count.longValue()));
        return page;
    }

    @Subscribe
    public void createAppListener(AppCreateEvent event) {
        AppDO app = event.getApp();
        AppLayoutEntity appLayoutDO = new AppLayoutEntity(true);
        appLayoutDO.setAppId(app.getId());
        JSONObject json = new JSONObject();
        json.put("0", (Object)new Long(this.defaultThemeId));
        appLayoutDO.setBrickIds(json.toJSONString());
        appLayoutDO.setThemeColor("#11c3bc");
        this.appLayoutService.insert(appLayoutDO);
    }

    @Subscribe
    public void floorSkinUpdateListener(FloorSkinUpdateEvent event) {
        Collection<Long> appIds = this.appLayoutService.useSkinAppIds(event.getSkinId());
        for (Long appId : appIds) {
            this.removeCacheByAppId(appId);
        }
    }

    @Override
    @Transactional(value="credits")
    public void updateThemeColor(Long appId, String color) throws BusinessException {
        AppSimpleDto app = this.appService.getObject(appId);
        if (Objects.equal(null, (Object)app)) {
            throw new BusinessException("App\u4e0d\u5b58\u5728");
        }
        try {
            this.appLayoutService.updateThemeColor(appId, color);
            this.appService.updateColor(appId, color);
            this.removeCacheByAppId(appId);
            AppUpdateEvent event = new AppUpdateEvent(appId);
            this.eventBus.post((Object)event);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u76ae\u80a4\u4e3b\u9898\u8272\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4fee\u6539\u76ae\u80a4\u4e3b\u9898\u8272\u5931\u8d25");
        }
    }

    @Override
    public void devSetSkin(Long appId, Long skinId) throws BusinessException {
        List<Long> specifyappIds;
        AppLayoutDto applayout = this.appLayoutService.buildAppLayoutByAppId(appId);
        if (Objects.equal(null, (Object)applayout)) {
            throw new BusinessException("\u6b64AppId\u4e0d\u5408\u6cd5");
        }
        CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(skinId);
        if (Objects.equal(null, (Object)skin)) {
            throw new BusinessException("\u8bbe\u7f6e\u7684\u76ae\u80a4\u4e0d\u5b58\u5728\u4e0d\u5408\u6cd5");
        }
        if (skin.getSpecify().booleanValue() && !(specifyappIds = this.creditsFloorSkinSpecifyService.selectSpecifyAppIdsBySkinId(skinId)).contains(appId)) {
            throw new BusinessException("\u6b64\u76ae\u80a4\u65e0\u6cd5\u4f7f\u7528");
        }
        JSONArray array = JSONArray.parseArray((String)skin.getSkinList());
        ArrayList floorList = Lists.newArrayList();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            FloorSortJson it = new FloorSortJson();
            it.setId(json.getLong("id"));
            it.setFloorType(json.getInteger("type"));
            it.setEnable(true);
            floorList.add(it);
        }
        this.appLayoutService.updateSkin(appId, skinId, floorList);
        this.removeCacheByAppId(appId);
    }

    @Override
    public void devReSetFloorList(Long appId, JSONArray floorSortList) throws BusinessException {
        JSONObject json;
        int i;
        AppLayoutDto applayout = this.getObject(appId);
        if (applayout == null) {
            throw new BusinessException("\u6b64AppId\u4e0d\u5408\u6cd5");
        }
        if (applayout.getSkinType() != 1) {
            throw new BusinessException("\u8001\u76ae\u80a4\u72b6\u6001\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        JSONArray array = applayout.getDevelopSortJson();
        if (array.size() != floorSortList.size()) {
            throw new BusinessException("\u697c\u5c42\u914d\u7f6e\u4e2a\u6570\u4e0e\u76ae\u80a4\u4e0d\u4e00\u81f4");
        }
        HashMap map = Maps.newHashMap();
        for (i = 0; i < array.size(); ++i) {
            json = array.getJSONObject(i);
            map.put(json.getLong("id"), json.getInteger("floorType"));
        }
        for (i = 0; i < floorSortList.size(); ++i) {
            json = floorSortList.getJSONObject(i);
            if (!map.containsKey(json.getLong("id"))) {
                throw new BusinessException("\u63d0\u4ea4\u7684\u697c\u5c42\u914d\u7f6e\u4e0e\u76ae\u80a4\u4e0d\u4e00\u81f4");
            }
            int type = (Integer)map.get(json.getLong("id"));
            if (Objects.equal((Object)type, (Object)json.getInteger("floorType"))) continue;
            throw new BusinessException("\u63d0\u4ea4\u7684\u697c\u5c42\u914d\u7f6e\u4e0e\u76ae\u80a4\u4e0d\u4e00\u81f4");
        }
        this.appLayoutService.updateDevSortJsonByAppId(appId, floorSortList);
        this.removeCacheByAppId(appId);
    }

    @Override
    public Integer updateDevFloorConfigByAppId(Long appId, Long floorId, Map<String, Object> floorConfig) throws BusinessException {
        try {
            AppLayoutDto appLayoutDto = this.appLayoutService.buildAppLayoutByAppId(appId);
            if (appLayoutDto == null) {
                throw new BusinessException("\u5bf9\u5e94App\u4e0d\u5b58\u5728");
            }
            if (Objects.equal((Object)0, (Object)appLayoutDto.getSkinType())) {
                throw new BusinessException("App\u5904\u4e8e\u8001\u76ae\u80a4\u72b6\u6001,\u65e0\u6cd5\u66f4\u65b0\u697c\u5c42\u914d\u7f6e");
            }
            CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(appLayoutDto.getSkinId());
            Map typeMap = skin.getTypeMap();
            if (!typeMap.containsKey(floorId)) {
                throw new BusinessException("App\u6ca1\u6709\u8be5\u697c\u5c42\u914d\u7f6e, appId=" + appId + ", floorId=" + floorId);
            }
            Integer floorType = (Integer)typeMap.get(floorId);
            Class<? extends BaseJson> clazz = this.appLayoutService.getBaseJson(floorType);
            BaseJson jsonConfig = clazz.newInstance();
            BeanUtils.populate((Object)jsonConfig, floorConfig);
            ValidatorTool.valid((Object)jsonConfig);
            String json = JSONObject.toJSONString((Object)jsonConfig);
            Map<Long, JSONObject> jsonMap = this.transformJsonConfig(appLayoutDto.getDevelopDataShowJson(), typeMap);
            jsonMap.put(floorId, JSONObject.parseObject((String)json));
            int ret = this.appLayoutService.updateDevFloorConfigByAppId(appId, jsonMap);
            this.removeCacheByAppId(appId);
            return ret;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u697c\u5c42\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return 0;
        }
    }

    @Override
    public AppLayoutDto getObject(Long appId) {
        AppLayoutDto appLayoutDto = (AppLayoutDto)this.memcachedClient.get(this.getLayoutKey(appId));
        if (!Objects.equal(null, (Object)appLayoutDto)) {
            return appLayoutDto;
        }
        appLayoutDto = this.appLayoutService.buildAppLayoutByAppId(appId);
        if (Objects.equal(null, (Object)appLayoutDto)) {
            return null;
        }
        switch (appLayoutDto.getSkinType()) {
            case 0: {
                AppLayoutBrickDO brick = this.appLayoutBrickService.findCacheAppLayoutBrick(appLayoutDto.getBrickId());
                appLayoutDto.setBrickId(brick.getId());
                appLayoutDto.setBrickMd5(brick.getMd5());
                appLayoutDto.setImageStyle(brick.getImageStyle());
                break;
            }
            case 1: {
                CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(appLayoutDto.getSkinId());
                JSONArray skinArray = JSONArray.parseArray((String)skin.getSkinList());
                LinkedHashMap skinMap = Maps.newLinkedHashMap();
                for (int i = 0; i < skinArray.size(); ++i) {
                    JSONObject json = skinArray.getJSONObject(i);
                    skinMap.put(json.getLong("id"), json);
                }
                appLayoutDto.setDevelopDataShowJson(this.transformJsonConfig(appLayoutDto.getDevelopDataShowJson(), skin.getTypeMap()));
                JSONArray jsonArray = new JSONArray();
                HashSet devFloorIds = Sets.newHashSet();
                JSONArray developSortJson = appLayoutDto.getDevelopSortJson();
                Map jsonMap = appLayoutDto.getDevelopDataShowJson();
                for (int i = 0; i < developSortJson.size(); ++i) {
                    JSONObject json = developSortJson.getJSONObject(i);
                    Long floorId = json.getLong("id");
                    devFloorIds.add(floorId);
                    if (!skinMap.containsKey(floorId)) continue;
                    if (json.getInteger("floorType") == CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_PAGE) {
                        json.put("pageId", (Object)((JSONObject)skinMap.get(floorId)).getLong("pageId"));
                        JSONObject config = (JSONObject)jsonMap.get(floorId);
                        if (!config.containsKey((Object)"floorTitle") || StringUtils.isBlank((String)config.getString("floorTitle"))) {
                            config.put("floorTitle", (Object)((JSONObject)skinMap.get(floorId)).getString("name"));
                        }
                    }
                    jsonArray.add((Object)json);
                }
                Sets.SetView addIds = Sets.difference(skinMap.keySet(), (Set)devFloorIds);
                for (Long floorId : addIds) {
                    JSONObject json = (JSONObject)skinMap.get(floorId);
                    FloorSortJson it = new FloorSortJson();
                    it.setId(floorId);
                    it.setFloorType(json.getInteger("type"));
                    it.setEnable(false);
                    jsonArray.add(JSONObject.toJSON((Object)it));
                }
                appLayoutDto.setDevelopSortJson(jsonArray);
            }
        }
        this.memcachedClient.set(this.getLayoutKey(appId), (Object)appLayoutDto, 60);
        return appLayoutDto;
    }

    private Map<Long, JSONObject> transformJsonConfig(Map<Long, JSONObject> appFloorConfig, Map<Long, Integer> typeMap) {
        HashMap jsonMap = Maps.newHashMap(appFloorConfig);
        HashSet floorIds = Sets.newHashSet(jsonMap.keySet());
        for (Long floorId : Sets.difference(typeMap.keySet(), (Set)floorIds)) {
            jsonMap.put(floorId, new JSONObject());
        }
        for (Long floorId : Sets.difference((Set)floorIds, typeMap.keySet())) {
            jsonMap.remove(floorId);
        }
        for (Long floorId : jsonMap.keySet()) {
            JSONObject config = (JSONObject)jsonMap.get(floorId);
            if (typeMap.containsKey(floorId)) {
                try {
                    Integer type = typeMap.get(floorId);
                    BaseJson bean = this.appLayoutService.getBaseJson(type).newInstance();
                    BeanUtils.populate((Object)bean, (Map)config);
                    config = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bean));
                }
                catch (Exception e) {
                    log.error("json\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                }
            }
            jsonMap.put(floorId, config);
        }
        return jsonMap;
    }

    private String getLayoutKey(Long appId) {
        StringBuilder sb = new StringBuilder();
        sb.append("dcm_keyAppLayoutByAppId_").append(appId);
        return sb.toString();
    }

    private void removeCacheByAppId(Long appId) {
        this.memcachedClient.remove(this.getLayoutKey(appId));
        this.memcachedClient.remove("chaos.keyAppLayoutByAppId_" + appId);
    }

    class AppLayoutTransform {
        private boolean needSetAppCount = false;
        private List<AppLayoutBrickDO> list;
        private Map<Long, Long> idAndCount = new HashMap<Long, Long>();

        public AppLayoutTransform(Optional<List<AppLayoutBrickDO>> list) {
            this.list = (List)list.get();
        }

        private List<AppLayoutBrickDto> transform() {
            if (this.list.isEmpty()) {
                Collections.emptyList();
            }
            List newlist = Lists.transform(this.list, (Function)new Function<AppLayoutBrickDO, AppLayoutBrickDto>(){
                private Long isNewDate = new Date().getTime() - 259200000L;

                public AppLayoutBrickDto apply(AppLayoutBrickDO input) {
                    AppLayoutBrickDto dto = new AppLayoutBrickDto();
                    cn.com.duiba.wolf.utils.BeanUtils.copy((Object)((Object)input), (Object)dto);
                    if (AppLayoutTransform.this.needSetAppCount) {
                        dto.setAppCount((Long)AppLayoutTransform.this.idAndCount.get(input.getId()));
                    }
                    dto.setNew(Boolean.valueOf(input.getGmtCreate().getTime() > this.isNewDate));
                    return dto;
                }
            });
            return newlist;
        }

        public void setNeedSetAppCount(boolean needSetAppCount) {
            this.needSetAppCount = needSetAppCount;
            if (!needSetAppCount) {
                return;
            }
            HashSet idSet = Sets.newHashSet();
            for (AppLayoutBrickDO brickDO : this.list) {
                idSet.add(brickDO.getId());
            }
            ArrayList ids = Lists.newArrayList((Iterable)idSet);
            List<AppLayoutCountDo> countList = AppLayoutBoImpl.this.odpsAppLayoutStatDao.getLayoutCount(ids, DateUtil.getDayStr((Date)DateUtil.daysAddOrSub((Date)new Date(), (int)-1)));
            for (AppLayoutCountDo brick : countList) {
                this.idAndCount.put(brick.getId(), brick.getAppCount());
            }
        }
    }
}

