/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.AppUrlParams;
import cn.com.duiba.developer.center.biz.bo.AppManagerBo;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.runnble.SendSecretEmailTask;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.support.ThreadPoolDuibaService;
import cn.com.duiba.developer.center.common.tools.SwitchTool;
import cn.com.duiba.service.exception.BusinessException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppManagerBoImpl
implements AppManagerBo,
ApplicationContextAware {
    private ApplicationContext ctx;
    @Autowired
    private AppService appService;
    @Autowired
    private DeveloperService developerService;
    @Autowired
    private AppBudgetService appBudgetService;
    @Autowired
    private ThreadPoolDuibaService threadPoolDuibaService;
    @Autowired
    private AppExtraService appExtraService;

    @Override
    @Transactional(value="credits")
    public void updateAppInfo(AppInfoFromParams params) throws BusinessException {
        AppSimpleDto app = this.appService.getObject(params.getAppId());
        if (Objects.equals(null, app)) {
            throw new BusinessException("\u63d0\u4ea4\u7684AppId\u4e0d\u5b58\u5728");
        }
        AppSimpleDto app4u = new AppSimpleDto();
        app4u.setId(params.getAppId());
        app4u.setName(params.getAppName());
        app4u.setTitle(params.getAppTitle());
        app4u.setLogo(params.getLogo());
        app4u.setCreditsRate(params.getCreditsRate());
        app4u.setUnitName(params.getUnitName());
        app4u.setCategory1(params.getCategory1());
        app4u.setCategory2(params.getCategory2());
        app4u.setEarnCreditsUrl(params.getEarnCreditsUrl());
        this.appService.update(app4u);
        SwitchTool tool = SwitchTool.getSwitchTool((Long)params.getAppId(), (Integer)app.getAppSwitch());
        tool.setSwitchByBoundType(8, params.getCreditsDecimalPoint().booleanValue());
        tool.setSwitchByBoundType(12, params.getCreditsType().booleanValue());
        this.appService.updateSwitch(tool);
    }

    @Override
    @Transactional(value="credits")
    public void updateApiConfig(AppUrlParams appUrlParams) throws BusinessException {
        Long appId = appUrlParams.getId();
        AppSimpleDto app = this.appService.getObject(appId);
        if (Objects.equals(null, app)) {
            throw new BusinessException("app\u4e0d\u5b58\u5728");
        }
        AppSimpleDto update = new AppSimpleDto();
        update.setId(appId);
        if (app.isAppSwitch(18)) {
            String creditsRemainQueryUrl = StringUtils.trimToNull((String)appUrlParams.getCreditsRemainQueryUrl());
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String virtualUrl = StringUtils.trimToNull((String)appUrlParams.getVirtualExchangeUrl());
            update.setVirtualExchangeUrl(virtualUrl);
            if (update.getCreditsRemainQueryUrl() != null) {
                update.setEnable(Boolean.valueOf(true));
            }
        } else {
            String creditsRemainQueryUrl = StringUtils.trimToNull((String)appUrlParams.getCreditsRemainQueryUrl());
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String creditsConsumeNotifyUrl = StringUtils.trimToNull((String)appUrlParams.getCreditsConsumeNotifyUrl());
            update.setCreditsConsumeNotifyUrl(creditsConsumeNotifyUrl);
            String creditsConsumeRequestUrl = StringUtils.trimToNull((String)appUrlParams.getCreditsConsumeRequestUrl());
            update.setCreditsConsumeRequestUrl(creditsConsumeRequestUrl);
            String virtualUrl = StringUtils.trimToEmpty((String)appUrlParams.getVirtualExchangeUrl());
            update.setVirtualExchangeUrl(virtualUrl);
            update.checkApiEnableUpdate();
            String addCreditsUrl = StringUtils.trimToEmpty((String)appUrlParams.getAddCreditsUrl());
            this.appExtraService.updateAddCreditsUrl(app.getId(), addCreditsUrl);
        }
        this.appService.updateUrls(update);
    }

    @Override
    public void budgetConfig(AppBudgetDto appBudget) throws BusinessException {
        this.appBudgetService.updateForDeveloperBack(appBudget);
    }

    @Override
    public void doSendSecret(Long appId) throws BusinessException {
        AppSimpleDto app = this.appService.getObject(appId);
        if (Objects.equals(null, app)) {
            throw new BusinessException("App\u4e0d\u5b58\u5728");
        }
        if (app.getSendSecret().booleanValue()) {
            throw new BusinessException("\u6b64APP\u5df2\u7ecf\u53d1\u9001\u8fc7\u5bc6\u94a5");
        }
        DeveloperEntity dev = this.developerService.find(app.getDeveloperId());
        SendSecretEmailTask task = (SendSecretEmailTask)this.ctx.getBean(SendSecretEmailTask.class);
        task.setApp(app);
        task.setDeveloper(dev);
        this.threadPoolDuibaService.submit((Runnable)task, 10);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }
}

