/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.developer.center.api.domain.paramquery.WithdrawCashParams;
import cn.com.duiba.developer.center.biz.bo.DevWithdrawCashBo;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashAuditService;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashOrderService;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class DevWithdrawCashBoImpl
implements DevWithdrawCashBo {
    @Autowired
    private PlatformTransactionManager creditsTransactionManager;
    @Autowired
    private AmbDeveloperWithdrawCashAuditService ambDeveloperWithdrawCashAuditService;
    @Autowired
    private AmbDeveloperWithdrawCashOrderService ambDeveloperWithdrawCashOrderService;

    @Override
    public DubboResult<Tuple.Tuple2<AmbDeveloperWithdrawCashAuditDto, AmbDeveloperWithdrawCashOrderDto>> firstWithdrawToBankOrAlipay(WithdrawCashParams withdrawCashParams) throws Exception {
        AmbDeveloperWithdrawCashAuditDto cashAuditDO = null;
        AmbDeveloperWithdrawCashOrderDto cashOrderDO = null;
        TransactionStatus transaction = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            AmbDeveloperWithdrawCashAuditDto auditing = this.ambDeveloperWithdrawCashAuditService.findAuditing(withdrawCashParams.getDeveloperId(), withdrawCashParams.getCashType());
            if (auditing != null) {
                throw new BusinessException("\u8be5\u63d0\u73b0\u65b9\u5f0f\u5df2\u7ecf\u5b58\u5728\u5ba1\u6838\u4e2d\u7684\u7533\u8bf7\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\uff01");
            }
            this.ambDeveloperWithdrawCashAuditService.disableValidPassAudit(withdrawCashParams.getDeveloperId(), withdrawCashParams.getCashType());
            cashAuditDO = new AmbDeveloperWithdrawCashAuditDto(true);
            cashAuditDO.setDeveloperId(withdrawCashParams.getDeveloperId());
            cashAuditDO.setCashType(withdrawCashParams.getCashType());
            cashAuditDO.setBusinessLicencePic(withdrawCashParams.getBusinessLicencePic());
            cashAuditDO.setIdCardFrontPic(withdrawCashParams.getIdCardFrontPic());
            cashAuditDO.setIdCardBackPic(withdrawCashParams.getIdCardBackPic());
            cashAuditDO.setBank(withdrawCashParams.getBank());
            cashAuditDO.setBankProvince(withdrawCashParams.getBankProvince());
            cashAuditDO.setBankCity(withdrawCashParams.getBankCity());
            cashAuditDO.setBankBranchName(withdrawCashParams.getBankBranchName());
            cashAuditDO.setBankAccountNumber(withdrawCashParams.getBankAccountNumber());
            cashAuditDO.setBankAccountName(withdrawCashParams.getBankAccountName());
            cashAuditDO.setAlipayAccountName(withdrawCashParams.getAlipayAccountName());
            cashAuditDO.setAlipayAccountNumber(withdrawCashParams.getAlipayAccountNumber());
            cashAuditDO.setStatus("create");
            cashAuditDO.setRegisterEmail(withdrawCashParams.getRegisterEmail());
            cashAuditDO.setPhone(withdrawCashParams.getPhone());
            this.ambDeveloperWithdrawCashAuditService.insert(cashAuditDO);
            cashOrderDO = new AmbDeveloperWithdrawCashOrderDto(true);
            cashOrderDO.setDeveloperId(withdrawCashParams.getDeveloperId());
            cashOrderDO.setMoney(Long.valueOf(new BigDecimal("100").multiply(new BigDecimal(withdrawCashParams.getMoney())).longValue()));
            cashOrderDO.setStatus("create");
            cashOrderDO.setRequiredAudit(Boolean.valueOf(true));
            cashOrderDO.setAuditId(cashAuditDO.getId());
            if ("alipay".equals(cashAuditDO.getCashType())) {
                cashOrderDO.setDescription("\u63d0\u73b0\u5230\u652f\u4ed8\u5b9d\uff1a" + cashAuditDO.getAlipayAccountNumber());
            } else if ("bank".equals(cashAuditDO.getCashType())) {
                cashOrderDO.setDescription("\u63d0\u73b0\u5230\u94f6\u884c\u5361\uff1a" + cashAuditDO.getBankAccountNumber());
            }
            this.ambDeveloperWithdrawCashOrderService.insert(cashOrderDO);
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(transaction);
        }
        return DubboResult.successResult((Object)Tuple.tuple((Object)cashAuditDO, (Object)cashOrderDO));
    }

    @Override
    public void updateAuditAndOrderStatus(AmbDeveloperWithdrawCashAuditDto cashAuditDO, AmbDeveloperWithdrawCashOrderDto cashOrderDO) throws Exception {
        TransactionStatus transactionA = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            this.ambDeveloperWithdrawCashOrderService.updateStatusCreateToWaitPay(cashOrderDO.getId());
            this.ambDeveloperWithdrawCashAuditService.updateStatusCreateToWait(cashAuditDO.getId());
        }
        catch (Exception e) {
            transactionA.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(transactionA);
        }
    }
}

