/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeCopyDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.api.domain.dto.ShowcaseDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.bo.FloorBo;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import cn.com.duiba.developer.center.biz.entity.ShowcaseEntity;
import cn.com.duiba.developer.center.biz.event.FloorSkinCodeSynEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutBrickService;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeCopyService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorShowcaseService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinSpecifyService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FloorBoImpl
implements FloorBo {
    @Autowired
    private CreditsFloorCodeService creditsFloorCodeService;
    @Autowired
    private DeveloperService developerService;
    @Autowired
    private CreditsFloorSkinService creditsFloorSkinService;
    @Autowired
    private CreditsFloorCodeCopyService creditsFloorCodeCopyService;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private AppLayoutService appLayoutService;
    @Autowired
    private CreditsFloorSkinSpecifyService creditsFloorSkinSpecifyService;
    @Autowired
    private AppService appService;
    @Autowired
    private AppLayoutBrickService appLayoutBrickService;
    @Autowired
    CreditsFloorShowcaseService creditsFloorShowcaseService;
    Logger log = Logger.getLogger(FloorBoImpl.class);
    private Ordering<JSONObject> ordering = Ordering.natural().reverse().onResultOf((Function)new Function<JSONObject, Long>(){

        public Long apply(JSONObject skin) {
            if (skin.getShort("floorType") == 0) {
                return Long.MIN_VALUE;
            }
            return skin.getLong("id");
        }
    });

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
    }

    @Override
    public PaginationVO<JSONObject> getFloorPage(FloorPageParams params) throws BusinessException {
        if (null == params.getFloorType()) {
            throw new BusinessException("\u68c0\u7d22\u697c\u5c42\u5fc5\u987b\u6307\u5b9a\u697c\u5c42\u7c7b\u578b");
        }
        PaginationVO<CreditsFloorCodeDto> page = this.creditsFloorCodeService.selectFloorCodesByType(params);
        List list = page.getRows();
        ArrayList jlist = Lists.newArrayList();
        for (CreditsFloorCodeDto t : list) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)t.getId());
            json.put("name", (Object)t.getFloorName());
            json.put("modified", (Object)t.getGmtModified().getTime());
            json.put("image", (Object)t.getImage());
            jlist.add(json);
        }
        PaginationVO jsonpage = new PaginationVO();
        jsonpage.setRows((List)jlist);
        jsonpage.setTotalCount(page.getTotalCount());
        return jsonpage;
    }

    @Override
    @Transactional(value="credits")
    public CreditsFloorSkinDto insertFloorSkin(Optional<CreditsFloorSkinDto> dtoOpt) throws BusinessException {
        CreditsFloorSkinDto dto = (CreditsFloorSkinDto)dtoOpt.get();
        ValidatorTool.valid((Object)dto);
        String floors = dto.getSkinList();
        JSONArray jsonArray = JSONArray.parseArray((String)floors);
        jsonArray = this.verifFloorsJson(jsonArray);
        dto.setSkinList(jsonArray.toJSONString());
        dto = this.creditsFloorSkinService.insertFloorSkin(dto);
        this.eventBus.post((Object)new FloorSkinCodeSynEvent(dto.getId(), floors));
        return dto;
    }

    @Override
    @Transactional(value="credits")
    public int updateFloorSkin(Optional<CreditsFloorSkinDto> dtoOpt) throws BusinessException {
        CreditsFloorSkinDto dto = (CreditsFloorSkinDto)dtoOpt.get();
        ValidatorTool.valid((Object)dto);
        CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinForUpdate(dto.getId());
        if (skin == null) {
            throw new RuntimeException("\u66f4\u65b0\u7684\u76ae\u80a4\u4e0d\u5b58\u5728");
        }
        String floors = dto.getSkinList();
        JSONArray jsonArray = JSONArray.parseArray((String)floors);
        jsonArray = this.verifFloorsJson(jsonArray);
        dto.setSkinList(jsonArray.toJSONString());
        int ret = this.creditsFloorSkinService.updateFloorSkin(dto);
        if (ret > 0) {
            this.eventBus.post((Object)new FloorSkinCodeSynEvent(dto.getId(), floors));
        }
        return ret;
    }

    @Override
    public PaginationVO<JSONObject> getSkinPage(FloorPageParams params) {
        PaginationVO<CreditsFloorSkinDto> page = this.creditsFloorSkinService.selectFloorSkins(params);
        List list = page.getRows();
        PaginationVO jsonPage = new PaginationVO();
        jsonPage.setTotalCount(page.getTotalCount());
        if (!list.isEmpty()) {
            HashMap table = Maps.newHashMap();
            HashSet floorIdSet = Sets.newHashSet();
            for (CreditsFloorSkinDto it : list) {
                JSONArray array = JSONArray.parseArray((String)it.getSkinList());
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject floor = array.getJSONObject(i);
                    Long floorId = floor.getLong("id");
                    floorIdSet.add(floorId);
                }
            }
            List<CreditsFloorCodeDto> floorCodes = this.creditsFloorCodeService.selectFloorCodeList(floorIdSet);
            for (CreditsFloorCodeDto floor : floorCodes) {
                table.put(floor.getId(), floor.getMd5());
            }
            ArrayList skinJsonList = Lists.newArrayList();
            for (CreditsFloorSkinDto it : list) {
                JSONObject skin = new JSONObject();
                skin.put("id", (Object)it.getId());
                skin.put("name", (Object)it.getSkinName());
                skin.put("specify", (Object)it.getSpecify());
                skin.put("status", (Object)it.getStatus());
                JSONArray array = JSONArray.parseArray((String)it.getSkinList());
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < array.size(); ++i) {
                    String floorMd5;
                    JSONObject floor = array.getJSONObject(i);
                    Long floorId = floor.getLong("id");
                    String md5 = floor.getString("md5");
                    floor.put("needSyn", (Object)(!Objects.equal((Object)md5, (Object)(floorMd5 = (String)table.get(floorId))) ? 1 : 0));
                    jsonArray.add((Object)floor);
                }
                skin.put("floorList", (Object)jsonArray);
                skinJsonList.add(skin);
            }
            jsonPage.setRows((List)skinJsonList);
        }
        return jsonPage;
    }

    @Override
    public JSONObject getOneSkinConfig(Long id) throws BusinessException {
        CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(id);
        if (Objects.equal(null, (Object)skin)) {
            throw new BusinessException("\u65e0\u6b64\u76ae\u80a4");
        }
        JSONObject skinJson = new JSONObject();
        skinJson.put("id", (Object)skin.getId());
        skinJson.put("name", (Object)skin.getSkinName());
        skinJson.put("image", (Object)skin.getSkinImage());
        HashSet floorIds = Sets.newHashSet();
        JSONArray array = JSONArray.parseArray((String)skin.getSkinList());
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            Long floorId = json.getLong("id");
            floorIds.add(floorId);
        }
        List<CreditsFloorCodeDto> floorList = this.creditsFloorCodeService.selectFloorCodeList(floorIds);
        HashMap floorMd5Map = Maps.newHashMap();
        for (CreditsFloorCodeDto it : floorList) {
            floorMd5Map.put(it.getId(), it.getMd5());
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            Long floorId = json.getLong("id");
            json.put("needSyn", (Object)(!Objects.equal((Object)json.getString("md5"), floorMd5Map.get(floorId)) ? 1 : 0));
            jsonArray.add((Object)json);
        }
        skinJson.put("floors", (Object)jsonArray);
        return skinJson;
    }

    @Override
    public boolean switchSkinSpecify(Long id, Boolean isOpen) throws BusinessException {
        CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(id);
        if (skin == null) {
            throw new BusinessException("Id\u65e0\u6548");
        }
        if (isOpen == null) {
            throw new BusinessException("\u7f3a\u5931\u53c2\u6570");
        }
        if (isOpen.equals(skin.getSpecify())) {
            return isOpen;
        }
        if (isOpen.booleanValue()) {
            int count = this.appLayoutService.useSkinCount(id);
            if (count != 0) {
                throw new BusinessException("\u8be5\u76ae\u80a4\u5df2\u7ecf\u6709App\u4f7f\u7528,\u65e0\u6cd5\u518d\u5f00\u542f\u5b9a\u5411");
            }
            this.creditsFloorSkinService.switchSkinSpecify(id, true);
            return true;
        }
        int count = this.creditsFloorSkinSpecifyService.findSkinOpenSpecifyCount(id);
        if (count != 0) {
            throw new BusinessException("\u8be5\u76ae\u80a4\u5df2\u7ecf\u6709App\u53c2\u4e0e\u5b9a\u5411,\u65e0\u6cd5\u518d\u5173\u95ed\u5b9a\u5411\u5f00\u5173");
        }
        this.creditsFloorSkinService.switchSkinSpecify(id, false);
        return false;
    }

    @Override
    public boolean addAppSpecify(Long appId, Long skinId) throws BusinessException {
        CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(skinId);
        if (!skin.getSpecify().booleanValue()) {
            throw new BusinessException("\u8be5\u76ae\u80a4\u5b9a\u5411\u5f00\u5173\u8fd8\u672a\u6253\u5f00,\u65e0\u6cd5\u6dfb\u52a0\u5b9a\u5411");
        }
        int ret = this.creditsFloorSkinSpecifyService.addAppSpecify(appId, skinId);
        return ret == 1;
    }

    @Override
    public void saveShowcaseConfig(ShowcaseDto showcaseDto) throws BusinessException {
        ShowcaseEntity entity = new ShowcaseEntity();
        BeanUtils.copyProperties((Object)showcaseDto, (Object)entity);
        entity.setStatus("open");
        if (entity.getId() != null) {
            this.creditsFloorShowcaseService.updateShowcaseConfig(entity);
        } else {
            this.creditsFloorShowcaseService.saveShowcaseConfig(entity);
        }
    }

    @Override
    public void delShowcaseConfig(Long appId, Integer place) throws BusinessException {
        this.creditsFloorShowcaseService.delShowcaseConfig(appId, place);
    }

    @Override
    public List<AppSimpleDto> findAppSpecifyList(Long skinId) {
        CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(skinId);
        if (!skin.getSpecify().booleanValue()) {
            return Collections.emptyList();
        }
        List<Long> appIds = this.creditsFloorSkinSpecifyService.selectSpecifyAppIdsBySkinId(skinId);
        List<AppSimpleDto> appList = this.appService.findByAppIds(appIds);
        return appList;
    }

    @Override
    public List<JSONObject> loadDevSkinList(Long appId) throws BusinessException {
        JSONObject json;
        AppLayoutDto appLayout = this.appLayoutService.buildAppLayoutByAppId(appId);
        if (appLayout == null) {
            throw new BusinessException("appId is Invalid");
        }
        List<Long> skinIds = this.creditsFloorSkinSpecifyService.selectSkinIdBySpecifyAppId(appId);
        List<CreditsFloorSkinDto> skinList = this.creditsFloorSkinService.findDevSkinList(skinIds);
        List<JSONObject> array = Lists.newArrayList();
        HashSet idSet = Sets.newHashSet();
        for (CreditsFloorSkinDto skin : skinList) {
            JSONObject json2 = new JSONObject();
            json2.put("id", (Object)skin.getId());
            json2.put("floorType", (Object)1);
            json2.put("name", (Object)skin.getSkinName());
            json2.put("image", (Object)skin.getSkinImage());
            if (Objects.equal((Object)1, (Object)appLayout.getSkinType()) && Objects.equal((Object)skin.getId(), (Object)appLayout.getSkinId())) {
                json2.put("selected", (Object)true);
            } else {
                json2.put("selected", (Object)false);
            }
            array.add(json2);
            idSet.add(skin.getId());
        }
        if (appLayout.getSkinType() == 1 && !idSet.contains(appLayout.getSkinId())) {
            CreditsFloorSkinDto skin = this.creditsFloorSkinService.selectFloorSkinById(appLayout.getSkinId());
            json = new JSONObject();
            json.put("id", (Object)skin.getId());
            json.put("floorType", (Object)1);
            json.put("name", (Object)skin.getSkinName());
            json.put("image", (Object)skin.getSkinImage());
            json.put("selected", (Object)true);
            array.add(json);
        } else if (appLayout.getSkinType() == 0) {
            AppLayoutBrickDO brick = this.appLayoutBrickService.findCacheAppLayoutBrick(appLayout.getBrickId());
            json = new JSONObject();
            json.put("id", (Object)brick.getId());
            json.put("floorType", (Object)0);
            json.put("name", (Object)brick.getName());
            json.put("image", (Object)brick.getImage());
            json.put("selected", (Object)true);
            array.add(json);
        }
        array = this.ordering.sortedCopy((Iterable)array);
        return array;
    }

    private JSONArray verifFloorsJson(JSONArray jsonArray) throws BusinessException {
        JSONArray newJson = new JSONArray();
        if (jsonArray == null) {
            throw new RuntimeException("\u697c\u5c42\u914d\u7f6e\u5f02\u5e38");
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            if (!json.containsKey((Object)"id")) {
                throw new BusinessException("\u697c\u5c42Id\u7f3a\u5931");
            }
            if (!json.containsKey((Object)"name")) {
                throw new BusinessException("\u697c\u5c42\u540d\u79f0\u7f3a\u5931");
            }
            if (!json.containsKey((Object)"md5")) {
                throw new BusinessException("\u697c\u5c42md5\u7801\u7f3a\u5931");
            }
            if (!json.containsKey((Object)"type")) {
                throw new BusinessException("\u697c\u5c42\u7c7b\u578b\u7f3a\u5931");
            }
            if (Objects.equal((Object)json.getShort("type"), (Object)CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_PAGE) && !json.containsKey((Object)"pageId")) {
                throw new BusinessException("\u5b50\u9875\u9762\u7c7b\u578b\u7684\u697c\u5c42\u5fc5\u987b\u6307\u5b9a\u5177\u4f53\u5b50\u9875\u9762Id");
            }
            JSONObject floor = new JSONObject();
            floor.put("id", json.get((Object)"id"));
            floor.put("name", json.get((Object)"name"));
            floor.put("md5", json.get((Object)"md5"));
            floor.put("type", json.get((Object)"type"));
            if (json.containsKey((Object)"pageId")) {
                floor.put("pageId", json.get((Object)"pageId"));
            }
            newJson.add((Object)floor);
        }
        return newJson;
    }

    @Subscribe
    @Transactional(value="credits")
    public void SynCopyCode(FloorSkinCodeSynEvent event) throws BusinessException {
        Set updateSet;
        Set delSet;
        ValidatorTool.valid((Object)event);
        Map<Long, Boolean> synSyn = event.getSynMap();
        Long skinId = event.getSkinId();
        HashMap copyMap = Maps.newHashMap();
        final Set copyIds = copyMap.keySet();
        List<CreditsFloorCodeCopyDto> copyDtoList = this.creditsFloorCodeCopyService.seletListBySkinId(skinId);
        for (CreditsFloorCodeCopyDto it : copyDtoList) {
            copyMap.put(it.getFloorId(), it);
        }
        final Set<Long> floorIdSet = synSyn.keySet();
        HashMap floorMap = Maps.newHashMap();
        List<CreditsFloorCodeDto> floorlist = this.creditsFloorCodeService.selectFloorCodeList(floorIdSet);
        for (CreditsFloorCodeDto it : floorlist) {
            floorMap.put(it.getId(), it);
        }
        final Set addSet = Sets.filter(floorIdSet, (Predicate)new Predicate<Long>(){

            public boolean apply(Long input) {
                return !copyIds.contains(input);
            }
        });
        if (!addSet.isEmpty()) {
            ArrayList insertList = Lists.newArrayList();
            for (Long floorId : addSet) {
                CreditsFloorCodeDto code = (CreditsFloorCodeDto)floorMap.get(floorId);
                CreditsFloorCodeCopyDto insert = new CreditsFloorCodeCopyDto();
                insert.setFloorId(floorId);
                insert.setMd5(code.getMd5());
                insert.setSkinId(skinId);
                insert.setSourceUrl(code.getSourceUrl());
                insertList.add(insert);
            }
            this.creditsFloorCodeCopyService.insertFloorCodeCopyList(insertList);
        }
        if (!(delSet = Sets.filter(copyIds, (Predicate)new Predicate<Long>(){

            public boolean apply(Long input) {
                return !floorIdSet.contains(input);
            }
        })).isEmpty()) {
            this.creditsFloorCodeCopyService.deleteFloorCodeCopyList(skinId, delSet);
        }
        if (!(updateSet = Sets.filter(floorIdSet, (Predicate)new Predicate<Long>(){

            public boolean apply(Long input) {
                return !addSet.contains(input);
            }
        })).isEmpty()) {
            for (Long floorId : updateSet) {
                if (!synSyn.get(floorId).booleanValue()) continue;
                CreditsFloorCodeDto floor = (CreditsFloorCodeDto)floorMap.get(floorId);
                CreditsFloorCodeCopyDto copy = (CreditsFloorCodeCopyDto)copyMap.get(floorId);
                if (Objects.equal((Object)floor.getMd5(), (Object)copy.getMd5())) continue;
                CreditsFloorCodeCopyDto update = new CreditsFloorCodeCopyDto();
                update.setId(copy.getId());
                update.setMd5(floor.getMd5());
                update.setSourceUrl(floor.getSourceUrl());
                this.creditsFloorCodeCopyService.updateFloorCodeCopy(update);
            }
        }
    }

    @Override
    public List<FloorShowcaseContentDto> getShowcaseList(long appId) throws Exception {
        return this.creditsFloorShowcaseService.getShowcaseList(appId);
    }
}

