/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.bo.TagBo;
import cn.com.duiba.developer.center.biz.entity.AppTagsMaskingEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.TagsService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TagBoImpl
implements TagBo {
    @Autowired
    private AppService appService;
    @Autowired
    private TagsService tagsService;

    @Override
    @Transactional(value="credits")
    public void setShieldTags(Long appId, boolean autoRecommend, List<Long> tagids) {
        AppSimpleDto app = new AppSimpleDto();
        app.setId(appId);
        app.setAutoRecommend(Boolean.valueOf(autoRecommend));
        this.appService.update(app);
        this.tagsService.deleteTagMaskingByAppId(app.getId());
        if (CollectionUtils.isNotEmpty(tagids)) {
            AppTagsMaskingEntity appTags = new AppTagsMaskingEntity();
            for (Long id : tagids) {
                appTags.setAppId(app.getId());
                appTags.setTagsId(id);
                this.tagsService.insertTagMasking(appTags);
            }
        }
    }
}

