/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.dao.center_config;

import cn.com.duiba.developer.center.api.domain.paramquery.AppAerosolParams;
import cn.com.duiba.developer.center.biz.entity.AerosolEntity;
import cn.com.duiba.developer.center.biz.service.credits.aerosol.pojo.AerosolCount;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AerosolDao
extends BaseDao {
    public AerosolEntity findByAppId(Long appId) {
        return (AerosolEntity)((Object)this.selectOne("findByAppId", appId));
    }

    public List<AerosolEntity> findByAppIds(List<Long> appIds) {
        HashMap params = Maps.newHashMap();
        params.put("appIds", appIds);
        return this.selectList("findByAppIds", params);
    }

    public List<AerosolEntity> findByIds(List<Long> ids) {
        HashMap params = Maps.newHashMap();
        params.put("ids", ids);
        return this.selectList("findByIds", params);
    }

    public int batchInsert(List<AerosolEntity> list) {
        return this.insert("batchInsert", list);
    }

    public int batchComeToAerosol(List<Long> appIds, Long groupId, Boolean isShow) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appIds", appIds);
        params.put("groupId", groupId);
        params.put("isShow", isShow);
        return this.update("batchComeToAerosol", params);
    }

    public List<AerosolEntity> findAerosolByGroupId(Long groupId) {
        return this.selectList("findAerosolByGroupId", groupId);
    }

    public int batchUpdateAerosol(List<Long> appIds, AerosolEntity aerosol) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appIds", appIds);
        params.put("md5", aerosol.getMd5());
        params.put("configUrl", aerosol.getConfigUrl());
        return this.update("batchUpdateAerosol", params);
    }

    public int deleteAerosolByAppIds(List<Long> appIds) {
        if (appIds == null || appIds.isEmpty()) {
            return 0;
        }
        HashMap params = Maps.newHashMap();
        params.put("appIds", appIds);
        return this.delete("deleteAerosolByAppIds", params);
    }

    public List<AerosolCount> findGroupCounts(List<Long> groupIds) {
        HashMap params = Maps.newHashMap();
        params.put("groupIds", groupIds);
        return this.selectList("findGroupCounts", params);
    }

    public List<AerosolEntity> findAerosolPageList(AppAerosolParams params) {
        if (StringUtils.isNotBlank((String)params.getGroupName()) && params.getGroupIds().isEmpty()) {
            return Collections.emptyList();
        }
        return this.selectList("findAerosolPageList", params);
    }

    public Long findAerosolPageCount(AppAerosolParams params) {
        if (StringUtils.isNotBlank((String)params.getGroupName()) && params.getGroupIds().isEmpty()) {
            return 0L;
        }
        return (Long)this.selectOne("findAerosolPageCount", params);
    }

    public int updateAerosolShowByAppIds(List<Long> appIds, Boolean isShow) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appIds", appIds);
        params.put("isShow", isShow);
        return this.update("updateAerosolShowByAppIds", params);
    }

    public int batchUpdateGroupIdToNullByAppIds(List<Long> appIds) {
        HashMap params = Maps.newHashMap();
        params.put("appIds", appIds);
        return this.update("batchUpdateGroupIdToNullByAppIds", params);
    }
}

