/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.event;

import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;

public class FloorSkinCodeSynEvent {
    @NotNull
    private Long skinId;
    @NotNull
    private String floorsJsonArray;

    public FloorSkinCodeSynEvent(Long skinId, String floorsJsonArray) {
        this.skinId = skinId;
        this.floorsJsonArray = floorsJsonArray;
    }

    public Map<Long, Boolean> getSynMap() throws BusinessException {
        if (StringUtils.isBlank((String)this.floorsJsonArray)) {
            return Collections.emptyMap();
        }
        JSONArray jsonArray = JSONArray.parseArray((String)this.floorsJsonArray);
        HashMap synMap = Maps.newHashMap();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            if (!json.containsKey((Object)"id")) {
                throw new BusinessException("\u697c\u5c42Id\u7f3a\u5931");
            }
            if (!json.containsKey((Object)"syn")) {
                throw new BusinessException("\u697c\u5c42\u66f4\u65b0\u6807\u8bb0\u7f3a\u5931");
            }
            synMap.put(json.getLong("id"), json.getBoolean("syn"));
        }
        return synMap;
    }

    public String getFloorsJsonArray() {
        return this.floorsJsonArray;
    }

    public void setFloorsJsonArray(String floorsJsonArray) {
        this.floorsJsonArray = floorsJsonArray;
    }

    public Long getSkinId() {
        return this.skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }
}

