/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.floor;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteAppLayoutService;
import cn.com.duiba.developer.center.biz.bo.AppLayoutBo;
import cn.com.duiba.developer.center.biz.remoteservice.impl.RemoteAppBannerServiceNewImpl;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutService;
import cn.com.duiba.developer.center.common.tools.AppLogUtil;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONArray;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteAppLayoutServiceImpl
implements RemoteAppLayoutService {
    private static Logger logger = LoggerFactory.getLogger(RemoteAppBannerServiceNewImpl.class);
    @Autowired
    private AppLayoutBo appLayoutBo;
    @Autowired
    private AppLayoutService appLayoutService;

    public DubboResult<PaginationVO<AppLayoutBrickDto>> getSystemLayoutPage(PageQueryEntity params) {
        return DubboResult.successResult(this.appLayoutBo.getSystemThemeLayoutPage(params));
    }

    public DubboResult<PaginationVO<AppLayoutBrickDto>> getCustomLayoutPage(PageQueryEntity params) {
        return DubboResult.successResult(this.appLayoutBo.getCustomThemeLayoutPage(params));
    }

    public DubboResult<Boolean> updateThemeColor(Long appId, String color) {
        try {
            this.appLayoutBo.updateThemeColor(appId, color);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> devSetSkin(Long appId, Long skinId) {
        try {
            this.appLayoutBo.devSetSkin(appId, skinId);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> devReSetFloorList(Long appId, JSONArray floorSortList) {
        try {
            this.appLayoutBo.devReSetFloorList(appId, floorSortList);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateDevFloorConfigByAppId(Long appId, Long floorId, Map<String, Object> floorConfig) {
        try {
            Integer ret = this.appLayoutBo.updateDevFloorConfigByAppId(appId, floorId, floorConfig);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)logger, (String)"invoke updateDevFloorConfigByAppId failed, appId={}, floorId={}, floorConfig={}", (Object[])new Object[]{appId, floorId, floorConfig, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AppLayoutDto> getAppLayout(Long appId) {
        return DubboResult.successResult((Object)this.appLayoutBo.getObject(appId));
    }

    public DubboResult<Integer> getSkinType(Long appId) {
        try {
            AppLayoutDto dto = this.appLayoutBo.getObject(appId);
            if (dto == null) {
                throw new BusinessException("app\u65e0\u6548");
            }
            return DubboResult.successResult((Object)dto.getSkinType().intValue());
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

