/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.floor;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeCopyDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteCreditsFloorCodeService;
import cn.com.duiba.developer.center.biz.bo.FloorBo;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeCopyService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteCreditsFloorCodeServiceImpl
implements RemoteCreditsFloorCodeService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteCreditsFloorCodeServiceImpl.class);
    @Autowired
    private CreditsFloorCodeService creditsFloorCodeService;
    @Autowired
    private FloorBo floorBo;
    @Autowired
    private CreditsFloorCodeCopyService creditsFloorCodeCopyService;

    public DubboResult<CreditsFloorCodeDto> insertFloorCode(CreditsFloorCodeDto dto) {
        try {
            ValidatorTool.valid((Object)dto);
            CreditsFloorCodeDto floorCodeDto = this.creditsFloorCodeService.insertFloorCode(dto);
            return DubboResult.successResult((Object)floorCodeDto);
        }
        catch (Exception e) {
            logger.error("\u65b0\u5efa\u697c\u5c42\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateFloorCode(CreditsFloorCodeDto dto) {
        try {
            int ret = this.creditsFloorCodeService.updateFloorCode(dto);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u697c\u5c42\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PaginationVO<JSONObject>> selectFloorCodesByType(FloorPageParams params) {
        try {
            PaginationVO<JSONObject> page = this.floorBo.getFloorPage(params);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u697c\u5c42\u5217\u8868\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<CreditsFloorCodeDto> selectFloorCodeById(Long id) {
        try {
            CreditsFloorCodeDto dto = this.creditsFloorCodeService.selectFloorCodeById(id);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CreditsFloorCodeCopyDto>> seletCodeCopyListBySkinId(Long skinId) {
        try {
            List<CreditsFloorCodeCopyDto> list = this.creditsFloorCodeCopyService.seletListBySkinId(skinId);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CreditsFloorCodeDto>> getFloorCodeList(Collection<Long> ids) {
        try {
            List<CreditsFloorCodeDto> list = this.creditsFloorCodeService.selectFloorCodeList(ids);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

