/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.floor;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteCreditsFloorSkinService;
import cn.com.duiba.developer.center.biz.bo.FloorBo;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteCreditsFloorSkinServiceImpl
implements RemoteCreditsFloorSkinService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteCreditsFloorSkinServiceImpl.class);
    @Autowired
    private FloorBo floorBo;
    @Autowired
    private CreditsFloorSkinService creditsFloorSkinService;

    public DubboResult<PaginationVO<JSONObject>> getSkinPage(FloorPageParams params) {
        try {
            PaginationVO<JSONObject> page = this.floorBo.getSkinPage(params);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<CreditsFloorSkinDto> insertFloorSkin(CreditsFloorSkinDto dto) {
        try {
            ValidatorTool.valid((Object)dto);
            dto = this.floorBo.insertFloorSkin((Optional<CreditsFloorSkinDto>)Optional.of((Object)dto));
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u697c\u5c42\u76ae\u80a4\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateFloorSkin(CreditsFloorSkinDto dto) {
        try {
            ValidatorTool.valid((Object)dto);
            int ret = this.floorBo.updateFloorSkin((Optional<CreditsFloorSkinDto>)Optional.of((Object)dto));
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u697c\u5c42\u76ae\u80a4\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PaginationVO<JSONObject>> selectFloorSkins(FloorPageParams params) {
        try {
            PaginationVO<JSONObject> page = this.floorBo.getSkinPage(params);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<CreditsFloorSkinDto> selectFloorSkinById(Long id) {
        try {
            CreditsFloorSkinDto dto = this.creditsFloorSkinService.selectFloorSkinById(id);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<JSONObject> getOneSkinConfig(Long id) {
        try {
            JSONObject json = this.floorBo.getOneSkinConfig(id);
            return DubboResult.successResult((Object)json);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> switchSkinSpecify(Long id, Boolean isOpen) {
        try {
            return DubboResult.successResult((Object)this.floorBo.switchSkinSpecify(id, isOpen));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AppSimpleDto>> getSpecifyAppList(Long skinId) {
        return DubboResult.successResult(this.floorBo.findAppSpecifyList(skinId));
    }

    public DubboResult<Boolean> addAppSpecify(Long skinId, Long appId) {
        try {
            return DubboResult.successResult((Object)this.floorBo.addAppSpecify(appId, skinId));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> switchOpenState(Long skinId, Boolean isOpen) {
        return DubboResult.successResult((Object)this.creditsFloorSkinService.switchOpenState(skinId, isOpen));
    }

    public DubboResult<List<JSONObject>> loadDevSkinList(Long appId) {
        try {
            return DubboResult.successResult(this.floorBo.loadDevSkinList(appId));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

