/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AerosolDto;
import cn.com.duiba.developer.center.api.domain.dto.AerosolGroupDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppAerosolParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAerosolService;
import cn.com.duiba.developer.center.biz.bo.AerosolBo;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteAerosolServiceImpl
implements RemoteAerosolService {
    @Autowired
    private AerosolBo aerosolBo;

    public DubboResult<AerosolDto> loadAerosolConfig(Long appId) {
        return DubboResult.successResult((Object)this.aerosolBo.getAerosolDto(appId));
    }

    public DubboResult<AerosolDto> loadAerosolNoCache(Long appId) {
        return DubboResult.successResult((Object)this.aerosolBo.loadAerosolNoCache(appId));
    }

    public DubboResult<List<AerosolGroupDto>> loadAerosolGroup() {
        return DubboResult.successResult(this.aerosolBo.loadAerosolGroup());
    }

    public DubboResult<Long> createAerosolGroup(AerosolGroupDto groupDto) {
        try {
            ValidatorTool.valid((Object)groupDto);
            return DubboResult.successResult((Object)this.aerosolBo.createAerosolGroup(groupDto));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteAerosolGroup(Long id) {
        try {
            this.aerosolBo.deleteAerosolGroup(id);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> addToGroup(Long groupId, Long appId) {
        try {
            this.aerosolBo.addToGroup(groupId, appId);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> batchAddToGroup(Long groupId, Set<Long> appIds) {
        try {
            this.aerosolBo.batchAddToGroup(groupId, appIds);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delForGroup(Long appId) {
        try {
            this.aerosolBo.delForGroup(appId);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> synAerosolGroup(Long groupId, Set<Long> igenoreIds) {
        try {
            this.aerosolBo.synAerosolGroup(groupId, igenoreIds);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delAerosolByGroupId(Long groupId, Set<Long> igenoreIds) {
        try {
            this.aerosolBo.delAerosolByGroupId(groupId, igenoreIds);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delAerosolByAppId(Long appId) {
        try {
            this.aerosolBo.delAerosolByAppId(appId);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> createAerosol(AerosolDto config) {
        try {
            ValidatorTool.valid((Object)config);
            this.aerosolBo.createAerosol(config);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AerosolGroupDto> getAerosolGroupById(Long groupId) {
        try {
            return DubboResult.successResult((Object)this.aerosolBo.getAerosolGroupById(groupId));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateAerosolGroupShowStatus(Long groupId) {
        try {
            return DubboResult.successResult((Object)this.aerosolBo.updateAerosolGroupShowStatus(groupId));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateAerosolShowStatus(Long appId) {
        try {
            return DubboResult.successResult((Object)this.aerosolBo.updateAerosolShowStatus(appId));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateAerosol(AerosolDto config) {
        try {
            ValidatorTool.valid((Object)config);
            this.aerosolBo.updateAerosol(config);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AerosolDto>> loadGroupAppList(Long groupId) {
        try {
            return DubboResult.successResult(this.aerosolBo.loadGroupAppList(groupId));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateGroupConfig(AerosolGroupDto aerosolGroupDto) {
        try {
            ValidatorTool.valid((Object)aerosolGroupDto);
            return DubboResult.successResult((Object)this.aerosolBo.updateGroupConfig(aerosolGroupDto));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PaginationVO<AerosolDto>> loadAerosolList(AppAerosolParams entity) {
        try {
            return DubboResult.successResult(this.aerosolBo.loadAerosolPage(entity));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AerosolDto>> loadAerosolByAppIds(Set<Long> appIds) {
        try {
            return DubboResult.successResult(this.aerosolBo.loadAerosolByAppIds(appIds));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

