/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBannerDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppBannerServiceNew;
import cn.com.duiba.developer.center.biz.entity.AppBannerEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppBannerService;
import cn.com.duiba.developer.center.common.tools.AppLogUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteAppBannerServiceNewImpl
implements RemoteAppBannerServiceNew {
    private static Logger log = LoggerFactory.getLogger(RemoteAppBannerServiceNewImpl.class);
    @Autowired
    private AppBannerService appBannerService;

    public DubboResult<AppBannerDto> find(Long id) {
        try {
            AppBannerEntity entity = this.appBannerService.find(id);
            AppBannerDto dto = new AppBannerDto();
            ObjectUtil.convert((Object)entity, (Object)dto);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.find failed, id={}", (Object[])new Object[]{id, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateByIdAndAppId(AppBannerDto appBanner) {
        try {
            AppBannerEntity entity = new AppBannerEntity();
            ObjectUtil.convert((Object)appBanner, (Object)entity);
            Integer ret = this.appBannerService.updateByIdAndAppId(entity);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.update failed, appbanner={}", (Object[])new Object[]{appBanner, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> insert(AppBannerDto appBanner) {
        try {
            AppBannerEntity entity = new AppBannerEntity();
            ObjectUtil.convert((Object)appBanner, (Object)entity);
            this.appBannerService.insert(entity);
            appBanner.setId(entity.getId());
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.insert failed, appbanner={}", (Object[])new Object[]{appBanner, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> findMaxPlayload(Long appId, String type) {
        try {
            Integer maxPayload = this.appBannerService.findMaxPlayload(appId, type);
            return DubboResult.successResult((Object)maxPayload);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.findMaxPlayload failed, appId={}, type={}", (Object[])new Object[]{appId, type, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AppBannerDto>> findAllByAppId(Long appId, Boolean deleted) {
        try {
            List<AppBannerEntity> entityList = this.appBannerService.findAllByAppId(appId, deleted);
            return DubboResult.successResult(this.convertToAppBannerDto(entityList));
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.findAllByAppId failed, appId={}", (Object[])new Object[]{appId, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AppBannerDto>> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted) {
        try {
            List<AppBannerEntity> entityList = this.appBannerService.findAllByAppIdDeleteAndType(appId, type, deleted);
            return DubboResult.successResult(this.convertToAppBannerDto(entityList));
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.findAllByAppIdDeleteAndType failed, appId={}, type={}", (Object[])new Object[]{appId, type, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> sortByBannerIdAndRange(Long appId, Long bannerId, String type, Integer startPayload, Integer endPayload) {
        if (Objects.equal((Object)startPayload, (Object)endPayload)) {
            return DubboResult.successResult(null);
        }
        try {
            List<AppBannerEntity> entityList = this.appBannerService.findListBetweenPayload(appId, type, startPayload, endPayload);
            AppBannerEntity updateEntity = new AppBannerEntity();
            updateEntity.setAppId(appId);
            for (AppBannerEntity entity : entityList) {
                updateEntity.setId(entity.getId());
                if (Objects.equal((Object)entity.getId(), (Object)bannerId)) {
                    updateEntity.setPayload(endPayload);
                } else if (startPayload > endPayload) {
                    updateEntity.setPayload(entity.getPayload() + 1);
                } else {
                    updateEntity.setPayload(entity.getPayload() - 1);
                }
                this.appBannerService.updateByIdAndAppId(updateEntity);
            }
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.sortByBannerIdAndRange failed, appId={}, bannerId={}, type={}", (Object[])new Object[]{appId, bannerId, type, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AppBannerDto>> findBannerByItemId(Long appId, Long appItemId, String type) {
        try {
            List<AppBannerEntity> entityList = this.appBannerService.findBannerByItemId(appId, appItemId, type);
            return DubboResult.successResult(this.convertToAppBannerDto(entityList));
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke appBannerService.findBannerByItemId failed, appId={}, type={}", (Object[])new Object[]{appId, type, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    private List<AppBannerDto> convertToAppBannerDto(List<AppBannerEntity> entityList) {
        return Lists.transform(entityList, (Function)new Function<AppBannerEntity, AppBannerDto>(){

            public AppBannerDto apply(AppBannerEntity input) {
                AppBannerDto dto = new AppBannerDto();
                ObjectUtil.convert((Object)input, (Object)dto);
                return dto;
            }
        });
    }
}

