/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.AppUrlParams;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.developer.center.biz.bo.AppManagerBo;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteAppServiceImpl
implements RemoteAppService {
    @Autowired
    private AppBo appBo;
    @Autowired
    private AppBudgetService appBudgetService;
    @Autowired
    private AppManagerBo appManagerBo;

    public DubboResult<Long> createApp(CreateAppQueryParams param) {
        try {
            ValidatorTool.valid((Object)param);
            return DubboResult.successResult((Object)this.appBo.createApp(param));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AppSimpleDto> getSimpleApp(Long id) {
        return DubboResult.successResult((Object)this.appBo.getSimpleApp(id));
    }

    public DubboResult<AppBudgetDto> getAppBudget(Long id) {
        return DubboResult.successResult((Object)this.appBudgetService.getObject(id));
    }

    public DubboResult<Boolean> updateAppInfo(AppInfoFromParams params) {
        try {
            ValidatorTool.valid((Object)params);
            this.appManagerBo.updateAppInfo(params);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateApiConfig(AppUrlParams appUrlParams) {
        try {
            ValidatorTool.valid((Object)appUrlParams);
            this.appManagerBo.updateApiConfig(appUrlParams);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateBudgetConfig(AppBudgetDto appBudget) {
        try {
            ValidatorTool.valid((Object)appBudget);
            this.appManagerBo.budgetConfig(appBudget);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doSendSecret(Long appId) {
        try {
            this.appManagerBo.doSendSecret(appId);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

