/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.SupplierProductDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteSupplierProductsService;
import cn.com.duiba.developer.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.developer.center.biz.service.credits.SupplierProductsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteSupplierProductsServiceImpl
implements RemoteSupplierProductsService {
    @Autowired
    private SupplierProductsService supplierProductsService;

    public DubboResult<SupplierProductDto> findBySupplier(String supplier) {
        SupplierProductEntity s = this.supplierProductsService.findBySupplier(supplier);
        SupplierProductDto ret = new SupplierProductDto();
        ObjectUtil.convert((Object)s, (Object)ret);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<SupplierProductDto>> findAllBySupplier(String supplier) {
        ArrayList list = new ArrayList();
        List<SupplierProductEntity> l = this.supplierProductsService.findAllBySupplier(supplier);
        ObjectUtil.convertList(l, list, SupplierProductDto.class);
        return DubboResult.successResult(list);
    }

    public DubboResult<SupplierProductDto> findBySupplierAndProductId(String supplier, String productId) {
        SupplierProductEntity s = this.supplierProductsService.findBySupplierAndProductId(supplier, productId);
        SupplierProductDto ret = new SupplierProductDto();
        ObjectUtil.convert((Object)s, (Object)ret);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<SupplierProductDto>> findBySupplierAndFacePrice(String supplier, Integer facePrice) {
        ArrayList list = new ArrayList();
        List<SupplierProductEntity> l = this.supplierProductsService.findBySupplierAndFacePrice(supplier, facePrice);
        ObjectUtil.convertList(l, list, SupplierProductDto.class);
        return DubboResult.successResult(list);
    }

    public DubboResult<List<SupplierProductDto>> findBySupplierAndMobileAndProvince(String supplier, String mobile, String province) {
        ArrayList list = new ArrayList();
        List<SupplierProductEntity> l = this.supplierProductsService.findBySupplierAndMobileAndProvince(supplier, mobile, province);
        ObjectUtil.convertList(l, list, SupplierProductDto.class);
        return DubboResult.successResult(list);
    }

    public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByNameAndFacePrice(String supplier) {
        ArrayList list = new ArrayList();
        List<SupplierProductEntity> l = this.supplierProductsService.findAllBySupplierOrderByNameAndFacePrice(supplier);
        ObjectUtil.convertList(l, list, SupplierProductDto.class);
        return DubboResult.successResult(list);
    }

    public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByProvinceAndFacePrice(String supplier) {
        ArrayList list = new ArrayList();
        List<SupplierProductEntity> l = this.supplierProductsService.findAllBySupplierOrderByProvinceAndFacePrice(supplier);
        ObjectUtil.convertList(l, list, SupplierProductDto.class);
        return DubboResult.successResult(list);
    }

    public DubboResult<List<SupplierProductDto>> findAllBySupplierAndGameId(String supplier, String gameId) {
        ArrayList list = new ArrayList();
        List<SupplierProductEntity> l = this.supplierProductsService.findAllBySupplierAndGameId(supplier, gameId);
        ObjectUtil.convertList(l, list, SupplierProductDto.class);
        return DubboResult.successResult(list);
    }

    public DubboResult<List<SupplierProductDto>> findAllByIds(List<Long> ids) {
        ArrayList list = new ArrayList();
        List<SupplierProductEntity> l = this.supplierProductsService.findAllByIds(ids);
        ObjectUtil.convertList(l, list, SupplierProductDto.class);
        return DubboResult.successResult(list);
    }

    public void insert(SupplierProductDto supplierProductDO) {
        SupplierProductEntity s = new SupplierProductEntity();
        ObjectUtil.convert((Object)supplierProductDO, (Object)s);
        this.supplierProductsService.insert(s);
    }

    public void update(SupplierProductDto supplierProductDO) {
        SupplierProductEntity s = new SupplierProductEntity();
        ObjectUtil.convert((Object)supplierProductDO, (Object)s);
        this.supplierProductsService.update(s);
    }

    public DubboResult<SupplierProductDto> find(Long id) {
        SupplierProductEntity s = this.supplierProductsService.find(id);
        SupplierProductDto ret = new SupplierProductDto();
        ObjectUtil.convert((Object)s, (Object)ret);
        return DubboResult.successResult((Object)ret);
    }
}

