/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppTagDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteTagService;
import cn.com.duiba.developer.center.biz.bo.TagBo;
import cn.com.duiba.developer.center.biz.entity.TagEntity;
import cn.com.duiba.developer.center.biz.service.credits.TagsService;
import cn.com.duiba.developer.center.common.tools.AppLogUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteTagServiceImpl
implements RemoteTagService {
    private static Logger log = LoggerFactory.getLogger(RemoteTagServiceImpl.class);
    @Autowired
    private TagsService tagsService;
    @Autowired
    private TagBo tagBo;

    public DubboResult<List<AppTagDto>> getRecommendedTags(final Long appId) {
        try {
            List<TagEntity> tags = this.tagsService.findAllTags();
            final List<Long> shieldTagIds = this.tagsService.findShieldTagsByAppId(appId);
            List appTagList = Lists.transform(tags, (Function)new Function<TagEntity, AppTagDto>(){

                public AppTagDto apply(TagEntity input) {
                    AppTagDto tagDto = new AppTagDto();
                    tagDto.setAppId(appId);
                    tagDto.setTagId(input.getId());
                    tagDto.setTagName(input.getName());
                    if (shieldTagIds.contains(input.getId())) {
                        tagDto.setShield(true);
                    }
                    return tagDto;
                }
            });
            return DubboResult.successResult((Object)appTagList);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"getRecommendedTags failed, appId={}", (Object[])new Object[]{appId, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> setShieldTags(Long appId, boolean autoRecommend, List<Long> tagids) {
        try {
            this.tagBo.setShieldTags(appId, autoRecommend, tagids);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"invoke setShieldTags failed, appId={}, autoRecommend={}, tagids={}", (Object[])new Object[]{appId, autoRecommend, tagids, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

