/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.runnble;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterKeyService;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class InternalLetterTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(InternalLetterTask.class);
    @Autowired
    private InternalLetterService internalLetterService;
    @Autowired
    private InternalLetterKeyService internalLetterKeyService;
    @Autowired
    private DeveloperService developerService;
    @NotNull
    private Long letterId;

    @Override
    @Transactional(value="manager")
    public void run() {
        try {
            ValidatorTool.valid((Object)this);
            InternalLetterDO letterDO = this.internalLetterService.findForUpdate(this.letterId);
            if (Objects.equal(null, (Object)letterDO)) {
                throw new Exception("\u7ad9\u5185\u4fe1\u4e0d\u5b58\u5728");
            }
            if (letterDO.getSendStatue() == 1 || letterDO.getDeleted().booleanValue()) {
                return;
            }
            if (new Date().before(letterDO.getSendTime())) {
                return;
            }
            Set<Long> ids = this.getAllDeveloperIdSet(letterDO);
            int count = this.internalLetterKeyService.batchInsert(letterDO, Lists.newArrayList(ids));
            if (ids.size() != count) {
                throw new Exception("\u7ad9\u5185\u4fe1\u63a8\u9001\u7f3a\u5931");
            }
            this.internalLetterService.updateSendStatue(this.letterId);
        }
        catch (Exception e) {
            log.error("\u7ad9\u5185\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Set<Long> getAllDeveloperIdSet(InternalLetterDO letterDO) {
        if (Objects.equal((Object)"all", (Object)letterDO.getDestinations())) {
            return Sets.newHashSet(this.developerService.findAllEnbleId());
        }
        Splitter spl = Splitter.on((String)",").trimResults().omitEmptyStrings();
        Iterator it = spl.split((CharSequence)letterDO.getDestinations()).iterator();
        HashSet idSet = Sets.newHashSet();
        while (it.hasNext()) {
            try {
                idSet.add(Long.valueOf((String)it.next()));
            }
            catch (NumberFormatException e) {}
        }
        return idSet;
    }

    public Long getLetterId() {
        return this.letterId;
    }

    public void setLetterId(Long letterId) {
        this.letterId = letterId;
    }
}

