/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits;

import cn.com.duiba.developer.center.api.domain.dto.CenterConfigDto;
import cn.com.duiba.developer.center.api.domain.enums.CenterConfigEnum;
import cn.com.duiba.developer.center.biz.dao.center_config.CenterConfigDao;
import cn.com.duiba.developer.center.biz.entity.CenterConfigEntity;
import cn.com.duiba.developer.center.common.support.Environment;
import cn.com.duiba.wolf.cache.CacheClient;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CenterConfigService {
    private static final String CACHE_KEY = "dcm_key_center_config_";
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private CenterConfigDao centerConfigDao;

    public CenterConfigDto findByType(CenterConfigEnum type) {
        String key = this.getKey(type.getType());
        CenterConfigDto config = (CenterConfigDto)this.memcachedClient.get(key);
        if (config == null) {
            CenterConfigEntity entity = this.centerConfigDao.findByType(type);
            config = new CenterConfigDto();
            try {
                BeanUtils.copyProperties((Object)config, (Object)((Object)entity));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!Environment.isDev()) {
                this.memcachedClient.set(key, (Object)config, 60);
            }
        }
        return config;
    }

    private String getKey(String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(CACHE_KEY).append(type);
        return sb.toString();
    }
}

