/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits;

import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.developer.center.biz.dao.developer.RemainingMoneyDao;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.event.DeveloperCreateEvent;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.google.common.eventbus.Subscribe;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RemainingMoneyService {
    @Autowired
    private BizEventBus eventBus;
    @Value(value="${dcm.balance.key}")
    private String privateKey;
    @Resource
    private RemainingMoneyDao remainingMoneyDao;

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public void initDeveloperRemainingMoneyListener(DeveloperCreateEvent event) {
        DeveloperEntity developer = event.getDeveloper();
        RemainingMoneyDto rm = new RemainingMoneyDto(true);
        rm.setDeveloperId(developer.getId());
        rm.setMoney(Integer.valueOf(0));
        rm.setVersion(Long.valueOf(0L));
        Integer newMoney = rm.getMoney();
        Long newVersion = rm.getVersion();
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + newMoney.toString() + newVersion + newModifedStr));
        rm.setSign(newSign);
        this.remainingMoneyDao.insert(rm);
    }
}

