/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.aerosol;

import cn.com.duiba.developer.center.api.domain.paramquery.AppAerosolParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.dao.center_config.AerosolDao;
import cn.com.duiba.developer.center.biz.entity.AerosolEntity;
import cn.com.duiba.developer.center.biz.service.credits.aerosol.pojo.AerosolCount;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AerosolService {
    @Autowired
    private AerosolDao aerosolDao;
    @Autowired
    private CacheClient memcachedClient;

    private String getkeyByAppId(Long appId) {
        StringBuilder sb = new StringBuilder();
        sb.append("dcm_keyAppAerosolByAppId_");
        sb.append(appId);
        return sb.toString();
    }

    private void removeCache(Long appId) {
        String key = this.getkeyByAppId(appId);
        this.memcachedClient.remove(key);
    }

    private void removeCache(List<Long> appIds) {
        for (Long appId : appIds) {
            this.removeCache(appId);
        }
    }

    public AerosolEntity findByAppId(Long appId) {
        String key = this.getkeyByAppId(appId);
        AerosolEntity entity = (AerosolEntity)((Object)this.memcachedClient.get(key));
        if (entity == null) {
            entity = this.aerosolDao.findByAppId(appId);
            if (entity == null) {
                return null;
            }
            this.memcachedClient.set(key, (Object)entity, 60);
        }
        return entity;
    }

    public AerosolEntity findNoCacheByAppId(Long appId) {
        return this.aerosolDao.findByAppId(appId);
    }

    public List<AerosolEntity> findByAppIds(List<Long> appIds) {
        if (appIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.aerosolDao.findByAppIds(appIds);
    }

    public List<AerosolEntity> findByIds(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.aerosolDao.findByIds(ids);
    }

    public int batchInsert(List<AerosolEntity> list) {
        if (list.isEmpty()) {
            return 0;
        }
        return this.aerosolDao.batchInsert(list);
    }

    public int insertAerosol(AerosolEntity entity) {
        ArrayList list = Lists.newArrayList((Object[])new AerosolEntity[]{entity});
        return this.batchInsert(list);
    }

    public int comeToAerosol(Long appId, Long groupId, Boolean isShow) {
        ArrayList appIds = Lists.newArrayList((Object[])new Long[]{appId});
        return this.batchComeToAerosol(appIds, groupId, isShow);
    }

    public int batchComeToAerosol(List<Long> appIds, Long groupId, Boolean isShow) {
        if (appIds.isEmpty()) {
            return 0;
        }
        int ret = this.aerosolDao.batchComeToAerosol(appIds, groupId, isShow);
        this.removeCache(appIds);
        return ret;
    }

    public List<AerosolEntity> findAerosolByGroupId(Long groupId) {
        return this.aerosolDao.findAerosolByGroupId(groupId);
    }

    public int batchUpdateAerosol(List<Long> appIds, AerosolEntity aerosol) {
        if (StringUtils.isBlank((String)aerosol.getMd5()) || StringUtils.isBlank((String)aerosol.getConfigUrl())) {
            throw new RuntimeException("\u6d6e\u6807\u7684MD5\u548c\u914d\u7f6e\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (appIds.isEmpty()) {
            return 0;
        }
        int ret = this.aerosolDao.batchUpdateAerosol(appIds, aerosol);
        this.removeCache(appIds);
        return ret;
    }

    public int updateAerosol(AerosolEntity aerosol) {
        if (Objects.equals(null, aerosol.getAppId())) {
            throw new RuntimeException("\u66f4\u65b0\u6d6e\u6807\u914d\u7f6e\u7f3a\u5931AppId");
        }
        ArrayList appIds = Lists.newArrayList((Object[])new Long[]{aerosol.getAppId()});
        return this.batchUpdateAerosol(appIds, aerosol);
    }

    public int deleteAerosolByAppIds(List<Long> appIds) {
        if (appIds.isEmpty()) {
            return 0;
        }
        int ret = this.aerosolDao.deleteAerosolByAppIds(appIds);
        this.removeCache(appIds);
        return ret;
    }

    public int deleteAerosol(Long appId) {
        ArrayList appIds = Lists.newArrayList((Object[])new Long[]{appId});
        return this.deleteAerosolByAppIds(appIds);
    }

    public List<AerosolCount> findGroupCounts(List<Long> groupIds) {
        if (groupIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.aerosolDao.findGroupCounts(groupIds);
    }

    public PaginationVO<AerosolEntity> findAerosolPage(AppAerosolParams params) {
        List<AerosolEntity> list = this.aerosolDao.findAerosolPageList(params);
        Long count = this.aerosolDao.findAerosolPageCount(params);
        PaginationVO page = new PaginationVO();
        page.setRows(list);
        page.setTotalCount(count);
        return page;
    }

    public int updateAerosolShowByGroupStatus(Long groupId, Boolean isShow) {
        List<AerosolEntity> list = this.findAerosolByGroupId(groupId);
        if (list.isEmpty()) {
            return 0;
        }
        List appIds = Lists.transform(list, (Function)new Function<AerosolEntity, Long>(){

            public Long apply(AerosolEntity aerosolEntity) {
                return aerosolEntity.getAppId();
            }
        });
        int ret = this.aerosolDao.updateAerosolShowByAppIds(appIds, isShow);
        this.removeCache(appIds);
        return ret;
    }

    public int updateAerosolShowByAppId(Long appId, Boolean isShow) {
        ArrayList appIds = Lists.newArrayList((Object[])new Long[]{appId});
        int ret = this.aerosolDao.updateAerosolShowByAppIds(appIds, isShow);
        this.removeCache(appIds);
        return ret;
    }

    public int batchUpdateGroupIdToNullByAppIds(List<Long> appIds) {
        if (appIds.isEmpty()) {
            return 0;
        }
        int ret = this.aerosolDao.batchUpdateGroupIdToNullByAppIds(appIds);
        this.removeCache(appIds);
        return ret;
    }

    public int updateGroupIdToNullByAppId(Long appId) {
        ArrayList appIds = Lists.newArrayList((Object[])new Long[]{appId});
        return this.batchUpdateGroupIdToNullByAppIds(appIds);
    }
}

