/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.biz.dao.applayout.AppLayoutDao;
import cn.com.duiba.developer.center.biz.entity.AppLayoutEntity;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutService;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.ActivityJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.BannerJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.BaseJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.CouponJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.FloorSortJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.GoodsJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.IconJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.SnapUpJson;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppLayoutServiceImpl
implements AppLayoutService {
    private static final Logger log = LoggerFactory.getLogger(AppLayoutServiceImpl.class);
    private static final Map<Integer, Class<? extends BaseJson>> floorJsonMap = Maps.newHashMap();
    @Autowired
    private AppLayoutDao appLayoutDao;

    @Override
    public int insert(AppLayoutEntity appLayout) {
        return this.appLayoutDao.insert(appLayout);
    }

    @Override
    @Transactional(value="credits")
    public Integer updateSkin(Long appId, Long skinId, List<FloorSortJson> floorList) {
        JSONObject floorConfigJson = new JSONObject();
        for (FloorSortJson it : floorList) {
            floorConfigJson.put(it.getId().toString(), (Object)"{}");
        }
        String array = JSONArray.toJSONString(floorList);
        String floorConfigJsonStr = floorConfigJson.toJSONString();
        this.appLayoutDao.updateSkinId(appId, skinId);
        this.appLayoutDao.initFloorConfig(appId, array, floorConfigJsonStr);
        return 1;
    }

    @Override
    public AppLayoutDto buildAppLayoutByAppId(Long appId) {
        AppLayoutEntity entity = this.appLayoutDao.findByAppId(appId);
        if (Objects.equal(null, (Object)((Object)entity))) {
            return null;
        }
        AppLayoutDto dto = new AppLayoutDto();
        dto.setId(entity.getId());
        dto.setAppId(entity.getAppId());
        dto.setThemeColor(entity.getThemeColor());
        dto.setSkinType(entity.getSkinType());
        switch (entity.getSkinType()) {
            case 0: {
                JSONObject brickIds = JSONObject.parseObject((String)entity.getBrickIds());
                if (!brickIds.containsKey((Object)"0")) {
                    dto.setBrickId(Long.valueOf(1L));
                    break;
                }
                dto.setBrickId(brickIds.getLong("0"));
                break;
            }
            case 1: {
                dto.setSkinId(entity.getSkinId());
                JSONArray array = JSONArray.parseArray((String)entity.getDevelopSortJson());
                dto.setDevelopSortJson(array);
                String config = entity.getDevelopDataShowJson();
                JSONObject configJson = JSONObject.parseObject((String)config);
                HashMap configMap = Maps.newHashMap();
                for (String key : configJson.keySet()) {
                    configMap.put(Long.valueOf(key), JSONObject.parseObject((String)configJson.getString(key)));
                }
                dto.setDevelopDataShowJson((Map)configMap);
                break;
            }
            default: {
                log.error("\u51fa\u73b0\u672a\u77e5\u76ae\u80a4\u7c7b\u578b");
                throw new RuntimeException("\u51fa\u73b0\u672a\u77e5\u76ae\u80a4\u7c7b\u578b");
            }
        }
        return dto;
    }

    @Override
    public Integer updateDevFloorConfigByAppId(Long appId, Map<Long, JSONObject> jsonMap) {
        String config = JSONObject.toJSONString(jsonMap);
        return this.appLayoutDao.updateDevelopDataShowJsonByAppId(appId, config);
    }

    @Override
    public Integer updateDevSortJsonByAppId(Long appId, JSONArray sortJson) {
        try {
            if (sortJson == null || sortJson.isEmpty()) {
                throw new BusinessException("\u4f20\u5165\u697c\u5c42\u6392\u5e8f\u914d\u7f6e\u5f02\u5e38");
            }
            ArrayList sortlist = Lists.newArrayList();
            for (int i = 0; i < sortJson.size(); ++i) {
                JSONObject json = sortJson.getJSONObject(i);
                FloorSortJson item = new FloorSortJson();
                BeanUtils.populate((Object)item, (Map)json);
                ValidatorTool.valid((Object)item);
                sortlist.add(item);
            }
            return this.appLayoutDao.updateDevelopSortJsonByAppId(appId, JSONObject.toJSONString((Object)sortlist));
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u697c\u5c42\u6392\u5e8f\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Integer useSkinCount(Long skinId) {
        return this.appLayoutDao.useSkinCount(skinId);
    }

    @Override
    public Collection<Long> useSkinAppIds(Long skinId) {
        return this.appLayoutDao.useSkinAppIds(skinId);
    }

    @Override
    public void updateThemeColor(Long appId, String color) {
        this.appLayoutDao.updateColor(appId, color);
    }

    @Override
    public Class<? extends BaseJson> getBaseJson(Integer floorType) {
        if (floorJsonMap.containsKey(floorType)) {
            return floorJsonMap.get(floorType);
        }
        return BaseJson.class;
    }

    static {
        floorJsonMap.put(CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_BANNER, BannerJson.class);
        floorJsonMap.put(CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_ICON, IconJson.class);
        floorJsonMap.put(CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_GOODS, GoodsJson.class);
        floorJsonMap.put(CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_ROB, SnapUpJson.class);
        floorJsonMap.put(CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_PAGE, ActivityJson.class);
        floorJsonMap.put(CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_COUPON, CouponJson.class);
        floorJsonMap.put(CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_FLOOR_BYSELF, BaseJson.class);
    }
}

