/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorSkinDao;
import cn.com.duiba.developer.center.biz.event.FloorSkinUpdateEvent;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreditsFloorSkinServiceImpl
implements CreditsFloorSkinService {
    private static final Logger log = LoggerFactory.getLogger(CreditsFloorSkinServiceImpl.class);
    @Autowired
    private CreditsFloorSkinDao creditsFloorSkinDao;
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private BizEventBus eventBus;

    @Override
    public CreditsFloorSkinDto insertFloorSkin(CreditsFloorSkinDto dto) {
        return this.creditsFloorSkinDao.insertFloorSkin(dto);
    }

    @Override
    public int updateFloorSkin(CreditsFloorSkinDto dto) {
        int ret = this.creditsFloorSkinDao.updateFloorSkin(dto);
        this.removeCacheById(dto.getId());
        return ret;
    }

    @Override
    public PaginationVO<CreditsFloorSkinDto> selectFloorSkins(FloorPageParams params) {
        PaginationVO page = new PaginationVO();
        Integer total = this.creditsFloorSkinDao.selectFloorSkinsCount();
        List<CreditsFloorSkinDto> list = this.creditsFloorSkinDao.selectFloorSkins((PageQueryEntity)params);
        page.setRows(list);
        page.setTotalCount(Long.valueOf(total.intValue()));
        return page;
    }

    @Override
    public CreditsFloorSkinDto selectFloorSkinById(Long id) {
        if (Objects.equals(null, id)) {
            throw new RuntimeException("\u697c\u5c42\u76ae\u80a4\u67e5\u8be2Id\u7f3a\u5931");
        }
        CreditsFloorSkinDto skin = (CreditsFloorSkinDto)this.memcachedClient.get(this.getSkinIdKey(id));
        if (Objects.equals(null, skin) && (skin = this.creditsFloorSkinDao.selectFloorSkinById(id)) != null) {
            this.memcachedClient.set(this.getSkinIdKey(id), (Object)skin, 300);
        }
        return skin;
    }

    @Override
    public CreditsFloorSkinDto selectFloorSkinForUpdate(Long id) {
        return this.creditsFloorSkinDao.selectFloorSkinForUpdate(id);
    }

    @Override
    public int switchSkinSpecify(Long id, Boolean isOpen) {
        int res = this.creditsFloorSkinDao.switchSkinSpecify(id, isOpen);
        this.removeCacheById(id);
        return res;
    }

    @Override
    public int switchOpenState(Long id, Boolean isOpen) {
        this.creditsFloorSkinDao.switchOpenState(id, isOpen);
        this.removeCacheById(id);
        return isOpen != false ? 1 : 0;
    }

    @Override
    public List<CreditsFloorSkinDto> findDevSkinList(List<Long> specifySkinIds) {
        List<CreditsFloorSkinDto> list = this.creditsFloorSkinDao.findDevCommonSkinList();
        if (CollectionUtils.isNotEmpty(specifySkinIds)) {
            List<CreditsFloorSkinDto> specifyList = this.creditsFloorSkinDao.findDevSpecifySkinList(specifySkinIds);
            list.addAll(specifyList);
        }
        return list;
    }

    private String getSkinIdKey(Long id) {
        StringBuilder sb = new StringBuilder();
        sb.append("dcm_keyFloorSkinId_").append(id);
        return sb.toString();
    }

    private void removeCacheById(Long id) {
        FloorSkinUpdateEvent event = new FloorSkinUpdateEvent(id);
        try {
            this.memcachedClient.remove(this.getSkinIdKey(id));
            this.eventBus.post((Object)event);
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u697c\u5c42\u76ae\u80a4\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
    }
}

