/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.biz.dao.app.AppBannerDao;
import cn.com.duiba.developer.center.biz.entity.AppBannerEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppBannerService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppBannerServiceImpl
implements AppBannerService {
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private AppBannerDao appBannerDao;

    @Override
    public AppBannerEntity find(Long id) {
        AppBannerEntity d = (AppBannerEntity)this.memcachedClient.get(this.getCacheKeyById(id));
        if (d == null && (d = this.appBannerDao.find(id)) != null) {
            this.memcachedClient.set(this.getCacheKeyById(id), (Object)d, 300);
        }
        return d;
    }

    @Override
    public Integer updateByIdAndAppId(AppBannerEntity appBanner) {
        Integer ret = this.appBannerDao.updateByIdAndAppId(appBanner);
        appBanner = this.find(appBanner.getId());
        this.removeCacheByAppId(appBanner.getAppId());
        this.memcachedClient.remove(this.getCacheKeyById(appBanner.getId()));
        return ret;
    }

    @Override
    public void insert(AppBannerEntity appBanner) {
        this.appBannerDao.insert(appBanner);
        this.removeCacheByAppId(appBanner.getAppId());
    }

    @Override
    public Integer findMaxPlayload(Long appId, String type) {
        return this.appBannerDao.findMaxPlayload(appId, type);
    }

    @Override
    public List<AppBannerEntity> findAllByAppId(Long appId, Boolean deleted) {
        return this.appBannerDao.findAllByAppId(appId, deleted);
    }

    @Override
    public List<AppBannerEntity> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted) {
        return this.appBannerDao.findAllByAppIdDeleteAndType(appId, type, deleted);
    }

    @Override
    public List<AppBannerEntity> findListBetweenPayload(Long appId, String type, Integer startPayload, Integer endPayload) {
        return this.appBannerDao.findListBetweenPayload(appId, type, startPayload, endPayload);
    }

    @Override
    public List<AppBannerEntity> findHomeBannerByCache(Long appId, boolean deleted) {
        String key = this.getCacheKeyByAppId(appId);
        List<AppBannerEntity> list = (List<AppBannerEntity>)this.memcachedClient.get(key);
        if (list == null && (list = this.findAllByAppId(appId, deleted)) != null) {
            this.memcachedClient.set(key, list, 120);
        }
        return list;
    }

    private String getCacheKeyById(Long id) {
        return "dcm_key_bannerId_" + id;
    }

    private String getCacheKeyByAppId(Long appId) {
        return "dcm_key_appBanners" + appId;
    }

    private void removeCacheByAppId(Long appId) {
        this.memcachedClient.remove(this.getCacheKeyByAppId(appId));
        String cacheKey = "item.MS_HOME_ITEM_-" + appId;
        this.memcachedClient.set(cacheKey, (Object)System.currentTimeMillis(), 3600);
    }

    @Override
    public List<AppBannerEntity> findBannerByItemId(Long appId, Long appItemId, String type) {
        return this.appBannerDao.findBannerByItemId(appId, appItemId, type);
    }
}

